/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.jsf2.bean.model.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IType;
import org.jboss.tools.common.model.XJob;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.jsf.JSFModelPlugin;
import org.jboss.tools.jsf.jsf2.bean.build.JSF2ProjectBuilder;
import org.jboss.tools.jsf.jsf2.bean.model.IJSF2ManagedBean;
import org.jboss.tools.jsf.jsf2.bean.model.IJSF2Project;
import org.jboss.tools.jsf.jsf2.bean.model.JSF2ProjectFactory;
import org.jboss.tools.jsf.jsf2.bean.model.impl.DefinitionContext;
import org.jboss.tools.jsf.jsf2.bean.model.impl.FacesConfigDefinition;
import org.jboss.tools.jsf.jsf2.bean.model.impl.JSF2ManagedBean;
import org.jboss.tools.jsf.jsf2.bean.model.impl.TypeDefinition;
import org.jboss.tools.jsf.jsf2.bean.scanner.lib.ClassPathMonitor;
import org.jboss.tools.jst.web.kb.internal.AbstractKbProjectExtension;
import org.jboss.tools.jst.web.kb.internal.IKbProjectExtension;

public class JSF2Project
extends AbstractKbProjectExtension
implements IJSF2Project {
    ClassPathMonitor classPath = new ClassPathMonitor(this);
    DefinitionContext definitions = new DefinitionContext();
    private Set<IJSF2ManagedBean> allBeans = new HashSet<IJSF2ManagedBean>();
    private Map<IPath, Set<IJSF2ManagedBean>> beansByPath = new HashMap<IPath, Set<IJSF2ManagedBean>>();
    private Map<String, Set<IJSF2ManagedBean>> beansByName = new HashMap<String, Set<IJSF2ManagedBean>>();
    private Set<IJSF2ManagedBean> namedBeans = new HashSet<IJSF2ManagedBean>();
    private boolean isMetadataComplete = false;

    public JSF2Project() {
        this.definitions.setProject(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<IJSF2ManagedBean> getManagedBeans() {
        HashSet<IJSF2ManagedBean> result = new HashSet<IJSF2ManagedBean>();
        JSF2Project jSF2Project = this;
        synchronized (jSF2Project) {
            result.addAll(this.namedBeans);
        }
        return result;
    }

    @Override
    public Set<IJSF2ManagedBean> getManagedBeans(IPath path) {
        HashSet<IJSF2ManagedBean> result = new HashSet<IJSF2ManagedBean>();
        Set<IJSF2ManagedBean> beans = this.beansByPath.get(path);
        if (beans != null && !beans.isEmpty()) {
            result.addAll(beans);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<IJSF2ManagedBean> getManagedBeans(String name) {
        HashSet<IJSF2ManagedBean> result = new HashSet<IJSF2ManagedBean>();
        JSF2Project jSF2Project = this;
        synchronized (jSF2Project) {
            Set<IJSF2ManagedBean> beans = this.beansByName.get(name);
            if (beans != null) {
                result.addAll(beans);
            }
        }
        return result;
    }

    @Override
    public boolean isMetadataComplete() {
        return this.isMetadataComplete;
    }

    public void setProject(IProject project) {
        super.setProject(project);
        this.classPath.init();
    }

    protected void resolveUsedProjectInJob(final IKbProjectExtension project) {
        XJob.addRunnableWithPriority((XJob.XRunnable)new XJob.XRunnable(){

            public void run() {
                project.resolve();
                project.update(true);
            }

            public String getId() {
                return "Build JSF2 Project " + project.getProject().getName();
            }
        });
    }

    public List<TypeDefinition> getAllTypeDefinitions() {
        Set ps = this.getUsedProjects(true);
        if (ps == null || ps.isEmpty()) {
            return this.getDefinitions().getTypeDefinitions();
        }
        List<TypeDefinition> ds = this.getDefinitions().getTypeDefinitions();
        ArrayList<TypeDefinition> result = new ArrayList<TypeDefinition>();
        result.addAll(ds);
        HashSet<IType> types = new HashSet<IType>();
        for (TypeDefinition d : ds) {
            IType t = d.getType();
            if (t == null) continue;
            types.add(t);
        }
        for (IKbProjectExtension p : ps) {
            List<TypeDefinition> ds2 = ((JSF2Project)p).getDefinitions().getTypeDefinitions();
            for (TypeDefinition d : ds2) {
                IType t = d.getType();
                if (t == null || types.contains(t)) continue;
                types.add(t);
                result.add(d);
            }
        }
        return result;
    }

    public DefinitionContext getDefinitions() {
        return this.definitions;
    }

    @Override
    public void pathRemoved(IPath path) {
        this.definitions.getWorkingCopy().clean(path);
    }

    public ClassPathMonitor getClassPath() {
        return this.classPath;
    }

    protected void build() {
        try {
            new JSF2ProjectBuilder(this);
        }
        catch (CoreException e) {
            JSFModelPlugin.getDefault().logError(e);
        }
    }

    public void clean() {
        File file = this.getStorageFile();
        if (file != null && file.isFile()) {
            file.delete();
        }
        this.isBuilt = false;
        this.classPath.clean();
        this.postponeFiring();
        this.fireChanges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(boolean updateDependent) {
        FacesConfigDefinition fc = this.definitions.getFacesConfig();
        this.isMetadataComplete = fc != null && fc.isMetadataComplete();
        List<TypeDefinition> typeDefinitions = this.getAllTypeDefinitions();
        ArrayList<JSF2ManagedBean> beans = new ArrayList<JSF2ManagedBean>();
        for (TypeDefinition typeDefinition : typeDefinitions) {
            if (!typeDefinition.isManagedBean()) continue;
            JSF2ManagedBean bean = new JSF2ManagedBean();
            bean.setDefinition(typeDefinition);
            beans.add(bean);
        }
        JSF2Project jSF2Project = this;
        synchronized (jSF2Project) {
            this.beansByPath.clear();
            this.beansByName.clear();
            this.namedBeans.clear();
            this.allBeans.clear();
        }
        if (!this.isMetadataComplete) {
            for (IJSF2ManagedBean iJSF2ManagedBean : beans) {
                this.addBean(iJSF2ManagedBean);
            }
        }
        if (updateDependent) {
            ArrayList arrayList = new ArrayList(this.usedBy);
            for (IKbProjectExtension p : arrayList) {
                p.update(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBean(IJSF2ManagedBean bean) {
        String name = bean.getName();
        if (name != null && name.length() > 0) {
            JSF2Project jSF2Project = this;
            synchronized (jSF2Project) {
                Set<IJSF2ManagedBean> bs = this.beansByName.get(name);
                if (bs == null) {
                    bs = new HashSet<IJSF2ManagedBean>();
                    this.beansByName.put(name, bs);
                }
                bs.add(bean);
                this.namedBeans.add(bean);
            }
        }
        IPath path = bean.getSourcePath();
        JSF2Project jSF2Project = this;
        synchronized (jSF2Project) {
            Set<IJSF2ManagedBean> bs = this.beansByPath.get(path);
            if (bs == null) {
                bs = new HashSet<IJSF2ManagedBean>();
                this.beansByPath.put(path, bs);
            }
            bs.add(bean);
            this.allBeans.add(bean);
        }
    }

    public void store() throws IOException {
        this.isBuilt = true;
    }

    private File getStorageFile() {
        IPath path = JSFModelPlugin.getDefault().getStateLocation();
        File file = new File(path.toFile(), "projects/" + this.project.getName());
        return file;
    }

    public void clearStorage() {
        File f = this.getStorageFile();
        if (f == null || !f.exists()) {
            return;
        }
        FileUtil.clear((File)f);
        f.delete();
    }

    public boolean hasNoStorage() {
        if (this.isBuilt) {
            return false;
        }
        File f = this.getStorageFile();
        return f == null || !f.exists();
    }

    protected IKbProjectExtension loadWithFactory(IProject project, boolean resolve) {
        return JSF2ProjectFactory.getJSF2Project(project, resolve);
    }

    public void dispose() {
        this.classPath.dispose();
    }
}

