/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.model;

import java.io.IOException;
import org.jboss.tools.common.model.loaders.EntityRecognizer;
import org.jboss.tools.common.model.loaders.EntityRecognizerContext;
import org.jboss.tools.common.model.loaders.XMLRecognizerContext;
import org.jboss.tools.common.xml.XMLEntityResolver;
import org.jboss.tools.jsf.JSFModelPlugin;
import org.jboss.tools.jsf.model.JSFConstants;

public class JSFEntityRecognizer
implements EntityRecognizer,
JSFConstants {
    static {
        try {
            Class<JSFEntityRecognizer> c = JSFEntityRecognizer.class;
            XMLEntityResolver.registerPublicEntity((String)"-//Sun Microsystems, Inc.//DTD JavaServer Faces Config 1.0//EN", c, (String)"/meta/web-facesconfig_1_0.dtd");
            XMLEntityResolver.registerPublicEntity((String)"-//Sun Microsystems, Inc.//DTD JavaServer Faces Config 1.1//EN", c, (String)"/meta/web-facesconfig_1_1.dtd");
        }
        catch (IOException e) {
            JSFModelPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    public String getEntityName(EntityRecognizerContext context) {
        String body = context.getBody();
        if (body == null) {
            return null;
        }
        XMLRecognizerContext xml = context.getXMLContext();
        if (xml.isDTD()) {
            String publicId = xml.getPublicId();
            String systemId = xml.getSystemId();
            String root = xml.getRootName();
            if (!"faces-config".equals(root)) {
                return null;
            }
            if ("-//Sun Microsystems, Inc.//DTD JavaServer Faces Config 1.0//EN".equals(publicId)) {
                return "FacesConfig";
            }
            if ("-//Sun Microsystems, Inc.//DTD JavaServer Faces Config 1.1//EN".equals(publicId)) {
                return "FacesConfig11";
            }
            if (systemId != null && systemId.indexOf("web-facesconfig_1_1.dtd") >= 0) {
                return "FacesConfig11";
            }
            return null;
        }
        String versionSuffix = this.getVersion(body);
        if ("12".equals(versionSuffix)) {
            return "FacesConfig12";
        }
        if ("20".equals(versionSuffix)) {
            return "FacesConfig20";
        }
        if ("22".equals(versionSuffix)) {
            return "FacesConfig22";
        }
        return null;
    }

    private String getVersion(String body) {
        String uriValue;
        int i = body.indexOf("<faces-config");
        if (i < 0) {
            return null;
        }
        int j = body.indexOf(">", i);
        if (j < 0) {
            return null;
        }
        String s = body.substring(i, j);
        if (s.indexOf(uriValue = "\"http://java.sun.com/xml/ns/javaee\"") >= 0) {
            if (s.indexOf("version=\"1.2\"") > 0) {
                return "12";
            }
            if (s.indexOf("version=\"2.0\"") > 0) {
                return "20";
            }
            if (s.indexOf("version=\"2.1\"") > 0) {
                return "20";
            }
        }
        if (s.indexOf(uriValue = "\"http://xmlns.jcp.org/xml/ns/javaee\"") >= 0 && s.indexOf("version=\"2.2\"") > 0) {
            return "22";
        }
        return null;
    }
}

