/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.model.helpers.converter;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.meta.action.XAction;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.FindObjectHelper;
import org.jboss.tools.jsf.messages.JSFUIMessages;
import org.jboss.tools.jsf.model.pv.JSFProjectsRoot;
import org.jboss.tools.jsf.model.pv.JSFProjectsTree;
import org.jboss.tools.jsf.model.pv.JSFPromptingProvider;
import org.jboss.tools.jst.web.model.pv.WebProjectNode;

public class OpenConverterHelper {
    public String run(XModel model, String converterId) {
        if (model == null || converterId == null) {
            return null;
        }
        if (converterId.length() == 0) {
            return JSFUIMessages.CONVERTER_ID_IS_NOT_SPECIFIED;
        }
        XModelObject c = this.findConverter(model, converterId);
        if (c == null) {
            return NLS.bind((String)JSFUIMessages.CANNOT_FIND_CONVERTER, (Object)converterId);
        }
        FindObjectHelper.findModelObject((XModelObject)c, (int)FindObjectHelper.EVERY_WHERE);
        return null;
    }

    String openClass(XModelObject c, String converterId) {
        String className = c.getAttributeValue("converter-class");
        if (className == null || className.length() == 0) {
            return NLS.bind((String)JSFUIMessages.ATTRIBUTE_CONVERTER_CLASS_FOR_CONVERTER_ISNOT_SPECIFIED, (Object)converterId);
        }
        XAction xaction = XActionInvoker.getAction((String)"OpenSource", (XModelObject)c);
        if (xaction != null && xaction.isEnabled(c)) {
            Properties p = new Properties();
            p.setProperty("ignoreWarning", "true");
            XActionInvoker.invoke((String)"OpenSource", (XModelObject)c, (Properties)p);
            return p.getProperty("error");
        }
        return null;
    }

    public XModelObject findConverter(XModel model, String converterId) {
        JSFProjectsRoot root = JSFProjectsTree.getProjectsRoot(model);
        if (root == null) {
            return null;
        }
        WebProjectNode n = (WebProjectNode)root.getChildByPath("Configuration");
        if (n == null) {
            return null;
        }
        XModelObject[] os = n.getTreeChildren();
        int i = 0;
        while (i < os.length) {
            XModelObject r = os[i].getChildByPath("Converters/" + converterId);
            if (r != null) {
                return r;
            }
            ++i;
        }
        return null;
    }

    public List<Object> getConverterIDs(XModel model) {
        JSFProjectsRoot root = JSFProjectsTree.getProjectsRoot(model);
        if (root == null) {
            return JSFPromptingProvider.EMPTY_LIST;
        }
        WebProjectNode n = (WebProjectNode)root.getChildByPath("Configuration");
        if (n == null) {
            return JSFPromptingProvider.EMPTY_LIST;
        }
        XModelObject[] os = n.getTreeChildren();
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (i < os.length) {
            XModelObject c = os[i].getChildByPath("Converters");
            if (c != null) {
                XModelObject[] cs = c.getChildren();
                int j = 0;
                while (j < cs.length) {
                    String id = cs[j].getAttributeValue("converter-id");
                    if (id != null && id.length() > 0) {
                        list.add(id);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return list;
    }
}

