/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.web.pattern;

import java.util.ArrayList;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.XModelObjectUtil;
import org.jboss.tools.jsf.web.pattern.CompoundPattern;
import org.jboss.tools.jsf.web.pattern.JSFUrlPattern;
import org.jboss.tools.jsf.web.pattern.PostfixUrlPattern;
import org.jboss.tools.jsf.web.pattern.PrefixUrlPattern;
import org.jboss.tools.jst.web.browser.wtp.RunOnServerContext;
import org.jboss.tools.jst.web.model.helpers.WebAppHelper;

public class PatternLoader {
    public static final String[] DEFAULT_SUFFIXES = new String[]{".jsp", ".xhtml", ".jspx"};
    public static JSFUrlPattern DEFAULT_PATTERN = new PostfixUrlPattern();
    static JSFUrlPattern[] DEFAULT_PATTERNS = new JSFUrlPattern[]{DEFAULT_PATTERN};
    CompoundPattern pattern = new CompoundPattern();
    private long timeStamp = -1L;

    public JSFUrlPattern getUrlPattern() {
        return this.pattern.patterns.length == 1 ? this.pattern.patterns[0] : this.pattern;
    }

    public void revalidate(XModelObject webxml) {
        if (webxml == null || webxml.getChildren().length == 0) {
            return;
        }
        if (this.timeStamp == webxml.getTimeStamp()) {
            return;
        }
        this.timeStamp = webxml.getTimeStamp();
        XModelObject[] mappings = WebAppHelper.getServletMappings((XModelObject)webxml);
        if (mappings.length == 0) {
            this.pattern.setPatterns(DEFAULT_PATTERNS);
            return;
        }
        String[] fileSuffixes = this.getFileSuffix(webxml);
        ArrayList<JSFUrlPattern> list = new ArrayList<JSFUrlPattern>();
        String servletName = this.getFacesServletName(webxml);
        int i = 0;
        while (i < mappings.length) {
            String servlet = mappings[i].getAttributeValue("servlet-name");
            if (servletName.equals(servlet)) {
                String pattern = mappings[i].getAttributeValue("url-pattern");
                JSFUrlPattern up = this.load(pattern);
                if (up instanceof PostfixUrlPattern) {
                    ((PostfixUrlPattern)up).setFileSuffixes(fileSuffixes);
                }
                if (up != null) {
                    list.add(up);
                }
            }
            ++i;
        }
        if (list.size() == 0 && fileSuffixes == DEFAULT_SUFFIXES) {
            this.pattern.setPatterns(DEFAULT_PATTERNS);
        } else if (list.size() == 0) {
            JSFUrlPattern[] ps = new JSFUrlPattern[]{new PostfixUrlPattern()};
            ((PostfixUrlPattern)ps[0]).setFileSuffixes(fileSuffixes);
            this.pattern.setPatterns(ps);
        } else {
            this.pattern.setPatterns(list.toArray(new JSFUrlPattern[0]));
        }
        RunOnServerContext.getInstance().revalidate();
    }

    String getFacesServletName(XModelObject webxml) {
        XModelObject s = WebAppHelper.findServlet((XModelObject)webxml, (String)"javax.faces.webapp.FacesServlet", null);
        return s != null ? s.getAttributeValue("servlet-name") : "FacesServlet";
    }

    String[] getFileSuffix(XModelObject webxml) {
        String[] list = WebAppHelper.getWebAppContextParamValueList((XModelObject)webxml, (String)"javax.faces.DEFAULT_SUFFIX");
        if (list != null && list.length == 1) {
            list = XModelObjectUtil.asStringArray((String)list[0].trim(), (String)" ");
        }
        return list == null || list.length == 0 || !list[0].startsWith(".") ? DEFAULT_SUFFIXES : list;
    }

    JSFUrlPattern load(String p) {
        if (p == null || p.length() == 0) {
            return null;
        }
        int s = p.indexOf(44);
        if (s > 0) {
            p = p.substring(0, s);
        }
        if (p.startsWith("*.")) {
            String n = p.substring(2);
            int i = 0;
            while (i < n.length()) {
                if (!Character.isJavaIdentifierPart(n.charAt(i))) {
                    return null;
                }
                ++i;
            }
            PostfixUrlPattern up = new PostfixUrlPattern();
            up.setPostfix(p.substring(1));
            return up;
        }
        if (p.endsWith("/*") && p.startsWith("/") && p.length() > 2) {
            String n = p.substring(1, p.length() - 2);
            int i = 0;
            while (i < n.length()) {
                if (!Character.isJavaIdentifierPart(n.charAt(i))) {
                    return null;
                }
                ++i;
            }
            PrefixUrlPattern up = new PrefixUrlPattern();
            up.setPrefix(p.substring(0, p.length() - 1));
            return up;
        }
        return null;
    }
}

