/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.web.validation;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.validation.IProjectValidationContext;
import org.jboss.tools.common.validation.ValidationErrorManager;
import org.jboss.tools.jsf.model.pv.JSFProjectsRoot;
import org.jboss.tools.jsf.model.pv.JSFProjectsTree;
import org.jboss.tools.jsf.web.JSFWebProject;
import org.jboss.tools.jsf.web.pattern.JSFUrlPattern;
import org.jboss.tools.jsf.web.validation.FacesConfigValidator;
import org.jboss.tools.jsf.web.validation.JSFSeverityPreferences;
import org.jboss.tools.jsf.web.validation.JSFValidationMessage;
import org.jboss.tools.jst.web.model.pv.WebProjectNode;
import org.jboss.tools.jst.web.validation.Check;

class JSFCheckToViewId
extends Check {
    public JSFCheckToViewId(ValidationErrorManager manager) {
        super(manager, JSFSeverityPreferences.INVALID_TO_VIEW_ID, "to-view-id");
    }

    public JSFCheckToViewId(ValidationErrorManager manager, String preference, String attr) {
        super(manager, preference, attr);
    }

    public void check(XModelObject object) {
        String value = object.getAttributeValue(this.attr);
        if (value == null) {
            return;
        }
        if (value.length() == 0) {
            this.fireMessage(object, JSFValidationMessage.TO_VIEW_ID_EMPTY, new String[]{this.attr});
        } else if (!value.startsWith("/")) {
            if (value.startsWith("#{")) {
                return;
            }
            this.fireMessage(object, JSFValidationMessage.VIEW_ID_NO_SLASH, new String[]{this.attr});
        } else if (value.indexOf("*") >= 0) {
            this.fireMessage(object, JSFValidationMessage.TO_VIEW_ID_STAR, new String[]{this.attr});
        } else {
            this.checkEsists(object, value);
        }
    }

    void checkEsists(XModelObject object, String value) {
        IProjectValidationContext context;
        IFile f;
        JSFUrlPattern pattern;
        if (value.indexOf(63) >= 0) {
            value = value.substring(0, value.indexOf(63));
        }
        if (value.indexOf("#{") > 0) {
            return;
        }
        XModel model = object.getModel();
        XModelObject o = model.getByPath(value);
        if (o == null && (pattern = JSFWebProject.getInstance(model).getUrlPattern()) != null && pattern.isJSFUrl(value)) {
            List<String> vs = pattern.getJSFPaths(value);
            for (String v : vs) {
                o = model.getByPath(v);
                if (o != null) break;
            }
            if (o == null) {
                o = model.getByPath(pattern.getJSFPath(value));
            }
        }
        if ((f = (IFile)object.getAdapter(IFile.class)) != null && (context = this.manager.getValidationContext()) != null) {
            context.addLinkedCoreResource(FacesConfigValidator.SHORT_ID, value, f.getFullPath(), true);
        }
        if (o != null) {
            IFile f2 = (IFile)o.getAdapter(IFile.class);
            if (f2 != null) {
                String path = f2.getLocation().toOSString().replace('\\', '/');
                IProjectValidationContext context2 = this.manager.getValidationContext();
                if (context2 != null) {
                    context2.addLinkedCoreResource(FacesConfigValidator.SHORT_ID, f2.getFullPath().toOSString(), f.getFullPath(), true);
                }
                if (path.endsWith(value)) {
                    return;
                }
            }
        } else if (this.checkTiles(model, value)) {
            return;
        }
        this.fireMessage(object, JSFValidationMessage.VIEW_NOT_EXISTS, new String[]{this.attr, value});
    }

    private boolean checkTiles(XModel model, String path) {
        JSFProjectsRoot root = JSFProjectsTree.getProjectsRoot(model);
        if (root == null) {
            return false;
        }
        XModelObject tiles = root.getChildByPath("Tiles");
        if (tiles == null) {
            return false;
        }
        XModelObject[] ts = ((WebProjectNode)tiles).getTreeChildren();
        if (ts.length == 0) {
            return false;
        }
        int d = path.lastIndexOf(46);
        if (d < 0) {
            return false;
        }
        String tileName = String.valueOf(path.substring(0, d + 1)) + "tiles";
        tileName = tileName.replace('/', '#');
        int i = 0;
        while (i < ts.length) {
            if (ts[i].getChildByPath(tileName) != null) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

