/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.web.validation;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolver;
import org.eclipse.wst.xml.core.internal.validation.XMLNestedValidatorContext;
import org.eclipse.wst.xml.core.internal.validation.core.LazyURLInputStream;
import org.eclipse.wst.xml.core.internal.validation.core.NestedValidatorContext;

public class XHTMLEntityResolver
implements XMLEntityResolver {
    private URIResolver uriResolver;
    private String resolvedDTDLocation;
    private NestedValidatorContext context;

    public XHTMLEntityResolver(URIResolver uriResolver, NestedValidatorContext context) {
        this.uriResolver = uriResolver;
        this.context = context;
    }

    public XMLInputSource resolveEntity(XMLResourceIdentifier rid) throws XNIException, IOException {
        XMLInputSource inputSource = XHTMLEntityResolver._internalResolveEntity(this.uriResolver, rid, this.context);
        if (inputSource != null) {
            this.resolvedDTDLocation = inputSource.getSystemId();
        }
        return inputSource;
    }

    public String getLocation() {
        return this.resolvedDTDLocation;
    }

    public static XMLInputSource _internalResolveEntity(URIResolver uriResolver, XMLResourceIdentifier rid) throws IOException {
        return XHTMLEntityResolver._internalResolveEntity(uriResolver, rid, null);
    }

    public static XMLInputSource _internalResolveEntity(URIResolver uriResolver, XMLResourceIdentifier rid, NestedValidatorContext context) throws IOException {
        XMLInputSource is = null;
        if (uriResolver != null) {
            String id = rid.getPublicId();
            if (id == null) {
                id = rid.getNamespace();
            }
            String location = null;
            if (id != null || rid.getLiteralSystemId() != null) {
                location = uriResolver.resolve(rid.getBaseSystemId(), id, rid.getLiteralSystemId());
            }
            if (location != null) {
                XMLNestedValidatorContext xmlContext;
                String physical = uriResolver.resolvePhysicalLocation(rid.getBaseSystemId(), id, location);
                if (context instanceof XMLNestedValidatorContext && (xmlContext = (XMLNestedValidatorContext)context).isURIMarkedInaccessible(physical)) {
                    throw new FileNotFoundException(physical);
                }
                if (physical.startsWith("file:") || physical.startsWith("jar:")) {
                    is = new XMLInputSource(rid.getPublicId(), location, location);
                    is.setByteStream((InputStream)new LazyURLInputStream(physical));
                }
            }
        }
        return is;
    }
}

