/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.angularjs.internal.ionic.palette.wizard;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.jst.angularjs.internal.ionic.palette.wizard.NewSpinnerWizardPage;
import org.jboss.tools.jst.angularjs.internal.ui.AngularJsUIImages;

public class AnimatedImage {
    private Image image;
    private int delay;
    private AnimatedImage next;

    private AnimatedImage() {
    }

    public static AnimatedImage create(String key) {
        ImageLoader loader = new ImageLoader();
        loader.load(NewSpinnerWizardPage.class.getResourceAsStream(key));
        ImageData[] data = loader.data;
        AnimatedImage first = new AnimatedImage();
        first.image = new Image((Device)Display.getDefault(), data[0]);
        first.delay = data[0].delayTime;
        AnimatedImage previous = first;
        int i = 1;
        while (i < data.length) {
            previous.next = new AnimatedImage();
            previous.next.image = new Image((Device)Display.getDefault(), data[i]);
            previous.next.delay = data[i].delayTime * 10;
            previous = previous.next;
            ++i;
        }
        previous.next = first;
        return first;
    }

    public static AnimatedImage create(String prefix, int number, int delay) {
        AnimatedImage first = null;
        AnimatedImage previous = null;
        int i = 1;
        while (i <= number) {
            AnimatedImage image = new AnimatedImage();
            if (first == null) {
                first = image;
            } else {
                previous.next = image;
            }
            image.image = AngularJsUIImages.getInstance().getOrCreateImage(String.valueOf(prefix) + i + ".png");
            image.delay = delay;
            previous = image;
            ++i;
        }
        previous.next = first;
        return first;
    }

    public Image getImage() {
        return this.image;
    }

    public int getDelay() {
        return this.delay;
    }

    public AnimatedImage next() {
        return this.next;
    }
}

