/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.angularjs.internal.ionic.palette.wizard;

import org.eclipse.swt.widgets.Button;
import org.jboss.tools.jst.angularjs.internal.ionic.palette.wizard.AnimatedImage;

public class AnimatedImageBinding {
    private AnimatedImage image;
    private Button button;
    private long nextTime = System.currentTimeMillis();
    private boolean redraw = false;

    public AnimatedImageBinding(AnimatedImage image, Button button) {
        this.image = image;
        this.button = button;
    }

    public void init(long time) {
        this.nextTime = time + (long)this.image.getDelay();
    }

    public void setTime(long time) {
        while (time > this.nextTime) {
            this.nextTime += (long)this.image.getDelay();
            this.image = this.image.next();
            this.redraw = true;
        }
    }

    public void redraw() {
        if (this.redraw && !this.isDisposed()) {
            this.button.setImage(this.image.getImage());
            this.redraw = false;
        }
    }

    public boolean isReadyToRedraw() {
        return this.redraw;
    }

    public boolean isDisposed() {
        return this.button.isDisposed();
    }

    public long getNextTime() {
        return this.nextTime;
    }
}

