/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.css.dialog.selector.dnd;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;
import org.jboss.tools.jst.web.ui.internal.css.dialog.selector.CSSSelectorPartComposite;
import org.jboss.tools.jst.web.ui.internal.css.dialog.selector.model.CSSContainer;
import org.jboss.tools.jst.web.ui.internal.css.dialog.selector.model.CSSRuleContainer;
import org.jboss.tools.jst.web.ui.internal.css.dialog.selector.model.CSSStyleSheetContainer;
import org.jboss.tools.jst.web.ui.internal.css.dialog.selector.model.CSSTreeNode;
import org.jboss.tools.jst.web.ui.internal.css.dialog.selector.selection.CSSSelectionEventManager;

public class CSSTableDropAdapter
extends DropTargetAdapter {
    private TableViewer tableViewer;
    private CSSSelectorPartComposite parent;
    private TreeViewer treeViewer;

    public CSSTableDropAdapter(CSSSelectorPartComposite parent, TreeViewer treeViewer, TableViewer tableViewer) {
        this.treeViewer = treeViewer;
        this.tableViewer = tableViewer;
        this.parent = parent;
    }

    public void drop(DropTargetEvent event) {
        if (event.data == null) {
            event.detail = 0;
        } else if (event.data.equals("css_selector_table_viwer")) {
            this.handleTableSelectionMove(event);
            event.detail = 0;
        } else if (event.data.equals("css_selector_tree_viwer")) {
            this.handleTreeSelectionMove(event);
            event.detail = 0;
        }
    }

    protected void handleTreeSelectionMove(DropTargetEvent event) {
        LinkedHashSet<String> itemsToMove = new LinkedHashSet<String>(0);
        TreeItem[] selectedItems = this.treeViewer.getTree().getSelection();
        if (selectedItems != null && selectedItems.length > 0) {
            int i = 0;
            while (i < selectedItems.length) {
                TreeItem item = selectedItems[i];
                CSSContainer container = ((CSSTreeNode)item.getData()).getCSSContainer();
                CSSTreeNode treeNode = (CSSTreeNode)item.getData();
                if (container instanceof CSSStyleSheetContainer) {
                    List<CSSTreeNode> children = treeNode.getChildren();
                    int j = 0;
                    while (j < children.size()) {
                        itemsToMove.add(children.get(j).toString());
                        ++j;
                    }
                } else if (container instanceof CSSRuleContainer) {
                    itemsToMove.add(treeNode.toString());
                }
                ++i;
            }
            this.filterExistingItems(itemsToMove);
            if (itemsToMove.size() != 0) {
                if (event.item == null) {
                    this.handleEndInsertFromTree(itemsToMove, event);
                } else {
                    this.handleMiddleInsertFromTree(itemsToMove, event);
                }
                this.parent.updateStyles();
            }
            this.treeViewer.getTree().deselectAll();
        }
    }

    protected void filterExistingItems(Set<String> itemsSet) {
        Object[] items = itemsSet.toArray();
        int i = 0;
        while (i < items.length) {
            if (this.isContain(items[i])) {
                itemsSet.remove(items[i]);
            }
            ++i;
        }
    }

    private boolean isContain(Object element) {
        TableItem[] items = this.tableViewer.getTable().getItems();
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                if (element.equals(items[i].getData())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected void handleEndInsertFromTree(Set<String> itemsToMove, DropTargetEvent event) {
        this.tableViewer.add((Object[])itemsToMove.toArray(new String[0]));
        this.tableViewer.getTable().setFocus();
        this.tableViewer.setSelection((ISelection)new StructuredSelection((Object[])itemsToMove.toArray(new String[0])), true);
    }

    protected void handleMiddleInsertFromTree(Set<String> itemsToMove, DropTargetEvent event) {
        Object[] selectedItems = itemsToMove.toArray(new String[0]);
        TableItem item = (TableItem)event.item;
        Point pt = Display.getCurrent().map(null, (Control)this.tableViewer.getTable(), event.x, event.y);
        Rectangle bounds = item.getBounds();
        int itemIndex = this.getItemIndex(item);
        if (pt.y < bounds.y + bounds.height / 2) {
            int i = 0;
            while (i < selectedItems.length) {
                itemIndex = this.getItemIndex(item);
                TableItem tableItem = new TableItem(this.tableViewer.getTable(), this.tableViewer.getTable().getStyle(), itemIndex);
                tableItem.setData(selectedItems[i]);
                ++i;
            }
            this.tableViewer.refresh();
            this.tableViewer.setSelection((ISelection)new StructuredSelection(selectedItems), true);
        } else if (pt.y >= bounds.y + bounds.height / 2) {
            int i = 0;
            while (i < selectedItems.length) {
                itemIndex = this.getItemIndex(item);
                if ((itemIndex = itemIndex + i + 1) > this.tableViewer.getTable().getItemCount()) {
                    itemIndex = this.tableViewer.getTable().getItemCount();
                }
                TableItem tableItem = new TableItem(this.tableViewer.getTable(), this.tableViewer.getTable().getStyle(), itemIndex);
                tableItem.setData(selectedItems[i]);
                ++i;
            }
            this.tableViewer.refresh();
            this.tableViewer.setSelection((ISelection)new StructuredSelection(selectedItems), true);
        }
    }

    public void dragOver(DropTargetEvent event) {
        event.feedback = 8;
        if (event.item != null) {
            TableItem item = (TableItem)event.item;
            Point pt = Display.getCurrent().map(null, (Control)this.tableViewer.getTable(), event.x, event.y);
            Rectangle bounds = item.getBounds();
            event.feedback = pt.y < bounds.y + bounds.height / 3 ? (event.feedback |= 2) : (pt.y > bounds.y + 2 * bounds.height / 3 ? (event.feedback |= 4) : (event.feedback |= 1));
        }
    }

    protected void handleTableSelectionMove(DropTargetEvent event) {
        if (event.item == null) {
            this.handleTableEndInsert(event);
        } else {
            this.handleTableMiddleInsert(event);
        }
        this.parent.updateStyles();
    }

    private int getItemIndex(TableItem item) {
        TableItem[] tableItems = this.tableViewer.getTable().getItems();
        int i = 0;
        while (i < tableItems.length) {
            if (item.getData().equals(tableItems[i].getData())) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    protected void handleTableEndInsert(DropTargetEvent event) {
        List<String> selectedCSSNames = this.getSelectedItems();
        CSSSelectionEventManager.getInstance().setHandleSelection(false);
        this.tableViewer.remove((Object[])selectedCSSNames.toArray(new String[0]));
        this.tableViewer.add((Object[])selectedCSSNames.toArray(new String[0]));
        this.tableViewer.setSelection((ISelection)new StructuredSelection(selectedCSSNames), true);
    }

    protected void handleTableMiddleInsert(DropTargetEvent event) {
        TableItem item = (TableItem)event.item;
        Point pt = Display.getCurrent().map(null, (Control)this.tableViewer.getTable(), event.x, event.y);
        Rectangle bounds = item.getBounds();
        int itemIndex = this.getItemIndex(item);
        List<String> selectedItems = this.getSelectedItems();
        if (selectedItems.contains(item.getData().toString())) {
            return;
        }
        if (pt.y < bounds.y + bounds.height / 3) {
            int i = 0;
            while (i < selectedItems.size()) {
                CSSSelectionEventManager.getInstance().setHandleSelection(false);
                this.tableViewer.remove((Object)selectedItems.get(i));
                itemIndex = this.getItemIndex(item);
                TableItem tableItem = new TableItem(this.tableViewer.getTable(), this.tableViewer.getTable().getStyle(), itemIndex);
                tableItem.setData((Object)selectedItems.get(i));
                ++i;
            }
            this.tableViewer.refresh();
            this.tableViewer.setSelection((ISelection)new StructuredSelection(selectedItems), true);
        } else if (pt.y > bounds.y + 2 * bounds.height / 3) {
            int i = 0;
            while (i < selectedItems.size()) {
                CSSSelectionEventManager.getInstance().setHandleSelection(false);
                this.tableViewer.remove((Object)selectedItems.get(i));
                itemIndex = this.getItemIndex(item);
                itemIndex = itemIndex + i + 1;
                if (itemIndex > this.tableViewer.getTable().getItemCount()) {
                    itemIndex = this.tableViewer.getTable().getItemCount();
                }
                TableItem tableItem = new TableItem(this.tableViewer.getTable(), this.tableViewer.getTable().getStyle(), itemIndex);
                tableItem.setData((Object)selectedItems.get(i));
                ++i;
            }
            this.tableViewer.refresh();
            this.tableViewer.setSelection((ISelection)new StructuredSelection(selectedItems), true);
        }
    }

    private List<String> getSelectedItems() {
        ArrayList<String> selectedNamesList = new ArrayList<String>(0);
        TableItem[] selectedItems = this.tableViewer.getTable().getSelection();
        if (selectedItems == null) {
            return selectedNamesList;
        }
        int i = 0;
        while (i < selectedItems.length) {
            selectedNamesList.add(selectedItems[i].getData().toString());
            ++i;
        }
        return selectedNamesList;
    }
}

