/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.css.dialog.selector.selection;

import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.jboss.tools.jst.web.ui.internal.css.dialog.selector.model.CSSContainer;
import org.jboss.tools.jst.web.ui.internal.css.dialog.selector.model.CSSRuleContainer;
import org.jboss.tools.jst.web.ui.internal.css.dialog.selector.model.CSSSelectorTreeModel;
import org.jboss.tools.jst.web.ui.internal.css.dialog.selector.model.CSSStyleSheetContainer;
import org.jboss.tools.jst.web.ui.internal.css.dialog.selector.model.CSSTreeNode;
import org.jboss.tools.jst.web.ui.internal.css.dialog.selector.selection.CSSClassSelectionChangedEvent;

public class CSSTreeSelectionChangedEvent
extends CSSClassSelectionChangedEvent {
    public CSSTreeSelectionChangedEvent(ISelectionProvider source, ISelection selection, CSSSelectorTreeModel model) {
        super(source, selection);
        this.model = model;
    }

    @Override
    public String[] getSelectedClassNames() {
        LinkedHashSet<String> selectedNames = new LinkedHashSet<String>(0);
        TreeSelection treeSelection = (TreeSelection)this.selection;
        Object[] selectedItems = treeSelection.toArray();
        int i = 0;
        while (i < selectedItems.length) {
            CSSTreeNode treeNode = (CSSTreeNode)selectedItems[i];
            CSSContainer container = treeNode.getCSSContainer();
            if (container instanceof CSSStyleSheetContainer) {
                List<CSSTreeNode> childNodes = treeNode.getChildren();
                for (CSSTreeNode cssTreeNode : childNodes) {
                    selectedNames.add(cssTreeNode.toString());
                }
            } else {
                selectedNames.add(treeNode.toString());
            }
            ++i;
        }
        return selectedNames.toArray(new String[0]);
    }

    @Override
    public CSSRuleContainer[] getSelectedRuleContainers() {
        LinkedHashSet<CSSRuleContainer> ruleContainers = new LinkedHashSet<CSSRuleContainer>(0);
        TreeSelection treeSelection = (TreeSelection)this.selection;
        Object[] selectedItems = treeSelection.toArray();
        int i = 0;
        while (i < selectedItems.length) {
            CSSTreeNode treeNode = (CSSTreeNode)selectedItems[i];
            CSSContainer container = treeNode.getCSSContainer();
            if (container instanceof CSSStyleSheetContainer) {
                List<CSSTreeNode> childNodes = treeNode.getChildren();
                for (CSSTreeNode cssTreeNode : childNodes) {
                    ruleContainers.add((CSSRuleContainer)cssTreeNode.getCSSContainer());
                }
            } else {
                ruleContainers.add((CSSRuleContainer)treeNode.getCSSContainer());
            }
            ++i;
        }
        return ruleContainers.toArray(new CSSRuleContainer[0]);
    }
}

