/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.editor.drop.treeviewer.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.editor.IModelObjectEditorInput;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.jst.web.project.list.WebPromptingProvider;
import org.jboss.tools.jst.web.ui.internal.editor.drop.treeviewer.model.AttributeValueResource;
import org.jboss.tools.jst.web.ui.internal.editor.drop.treeviewer.model.ModelElement;

public abstract class XModelAttributeValueResource
extends AttributeValueResource {
    protected IEditorInput editorInput;
    protected WebPromptingProvider provider;
    protected XModel xModel;
    protected XModelObject xModelObject;
    protected String path;

    public XModelAttributeValueResource(IEditorInput editorInput, ModelElement parent) {
        super(parent);
        this.editorInput = editorInput;
        this.init();
    }

    public XModelAttributeValueResource(IEditorInput editorInput, String name, ModelElement parent) {
        super(name, parent);
        this.editorInput = editorInput;
        this.init();
    }

    protected void init() {
        this.provider = WebPromptingProvider.getInstance();
        if (this.editorInput instanceof IModelObjectEditorInput) {
            this.xModelObject = ((IModelObjectEditorInput)this.editorInput).getXModelObject();
            this.xModel = this.xModelObject.getModel();
        } else if (this.editorInput instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)this.editorInput).getFile();
            this.xModelObject = EclipseResourceUtil.getObjectByResource((IResource)file);
            if (this.xModelObject != null) {
                this.xModel = this.xModelObject.getModel();
            }
        }
        if (this.xModelObject != null) {
            this.path = XModelObjectLoaderUtil.getResourcePath((XModelObject)this.xModelObject);
        }
    }

    protected boolean isReadyToUse() {
        return this.provider != null && this.xModel != null;
    }

    public WebPromptingProvider getProvider() {
        return this.provider;
    }

    public XModel getXModel() {
        return this.xModel;
    }
}

