/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.editor.jspeditor;

import java.util.ArrayList;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.INestableKeyBindingService;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.jboss.tools.common.core.resources.XModelObjectEditorInput;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.JSPMultiPageSelectionProvider;
import org.jboss.tools.jst.web.ui.internal.editor.selection.bar.SelectionBar;

public abstract class JSPMultiPageEditorPart
extends MultiPageEditorPart {
    private ArrayList<IEditorPart> nestedEditors = new ArrayList(3);
    private SelectionBar selectionBar;
    Composite ppp = null;

    protected JSPMultiPageEditorPart() {
    }

    public int addPage(IEditorPart editor, IEditorInput input, StructuredTextEditor sourcePart) throws PartInitException {
        Composite parent2;
        if (this.ppp == null) {
            IEditorSite site = this.createSite(editor);
            editor.init(site, input);
            this.ppp = parent2 = new Composite(this.getContainer(), 0);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            gridLayout.horizontalSpacing = 0;
            gridLayout.verticalSpacing = 0;
            parent2.setLayout((Layout)gridLayout);
            if (editor == sourcePart) {
                Composite editorComp = new Composite(parent2, 0);
                GridData gd = new GridData(4, 4, true, true);
                gd.horizontalSpan = 2;
                editorComp.setLayoutData((Object)new GridData(4, 4, true, true));
                editorComp.setLayout((Layout)new FillLayout(512));
                editor.createPartControl(editorComp);
            } else {
                editor.createPartControl(parent2);
            }
            this.selectionBar = new SelectionBar(sourcePart, parent2, 0);
            this.selectionBar.setLayoutData(new GridData(4, 0, true, false, 2, 1));
            editor.addPropertyListener(new IPropertyListener(){

                public void propertyChanged(Object source, int propertyId) {
                    JSPMultiPageEditorPart.this.handlePropertyChange(propertyId);
                }
            });
            this.nestedEditors.add(editor);
        } else {
            parent2 = this.ppp;
        }
        CTabItem item = this.createItem((Control)parent2);
        item.setData((Object)editor);
        return this.getPageCount() - 1;
    }

    private CTabItem createItem(Control control) {
        CTabItem item = new CTabItem((CTabFolder)this.getContainer(), 0);
        item.setControl(control);
        return item;
    }

    protected abstract IEditorSite createSite(IEditorPart var1);

    public void dispose() {
        if (this.selectionBar != null) {
            this.selectionBar.dispose();
        }
        this.getSite().setSelectionProvider(null);
        int i = 0;
        while (i < this.nestedEditors.size()) {
            IEditorPart editor = this.nestedEditors.get(i);
            this.disposePart((IWorkbenchPart)editor);
            ++i;
        }
        this.nestedEditors.clear();
    }

    protected IEditorPart getActiveEditor() {
        return super.getActiveEditor();
    }

    public SelectionBar getSelectionBar() {
        return this.selectionBar;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(XModelObjectEditorInput.checkInput((IEditorInput)input));
        site.setSelectionProvider((ISelectionProvider)new JSPMultiPageSelectionProvider(this));
    }

    private void disposePart(final IWorkbenchPart part) {
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() {
                if (part.getSite() instanceof MultiPageEditorSite) {
                    MultiPageEditorSite partSite = (MultiPageEditorSite)part.getSite();
                    partSite.dispose();
                }
                part.dispose();
            }

            public void handleException(Throwable e) {
            }
        });
    }

    public void setFocus() {
        this.setFocus(this.getActivePage());
    }

    private void setFocus(int pageIndex) {
        IKeyBindingService service = this.getSite().getKeyBindingService();
        if (pageIndex < 0 || pageIndex >= this.getPageCount()) {
            if (service instanceof INestableKeyBindingService) {
                INestableKeyBindingService nestableService = (INestableKeyBindingService)service;
                nestableService.activateKeyBindingService(null);
            }
            return;
        }
        IEditorPart editor = this.getEditor(pageIndex);
        if (editor != null) {
            editor.setFocus();
            if (service instanceof INestableKeyBindingService) {
                INestableKeyBindingService nestableService = (INestableKeyBindingService)service;
                if (editor != null) {
                    nestableService.activateKeyBindingService((IWorkbenchSite)editor.getEditorSite());
                } else {
                    nestableService.activateKeyBindingService(null);
                }
            }
        } else {
            Control control;
            if (service instanceof INestableKeyBindingService) {
                INestableKeyBindingService nestableService = (INestableKeyBindingService)service;
                nestableService.activateKeyBindingService(null);
            }
            if ((control = this.getControl(pageIndex)) != null) {
                control.setFocus();
            }
        }
    }

    public boolean isDirty() {
        for (IEditorPart editor : this.nestedEditors) {
            if (!editor.isDirty()) continue;
            return true;
        }
        return false;
    }
}

