/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.editor.jspeditor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.jboss.tools.jst.web.tld.TaglibData;
import org.jboss.tools.jst.web.tld.VpeTaglibListener;
import org.jboss.tools.jst.web.tld.VpeTaglibManager;
import org.jboss.tools.jst.web.ui.internal.editor.editor.IVisualContext;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.JSPMultiPageEditor;
import org.jboss.tools.jst.web.ui.internal.editor.util.XmlUtil;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SourceEditorPageContext
implements IVisualContext,
VpeTaglibManager {
    private List<TaglibData> taglibs = null;
    private IDocument iDocument;
    private Node referenceNode = null;
    private IVisualContext pageContext;

    public SourceEditorPageContext(JSPMultiPageEditor externalEditor) {
        if (externalEditor != null && externalEditor.getVisualEditor() != null && externalEditor.getVisualEditor().getController() != null) {
            this.setPageContext(externalEditor.getVisualEditor().getController().getPageContext());
        }
    }

    public void clearAll() {
        this.setTaglibs(null);
    }

    public void dispose() {
        this.clearAll();
        this.setReferenceNode(null);
        this.setPageContext(null);
        this.iDocument = null;
    }

    public void setReferenceNode(Node refNode) {
        if (refNode == null || refNode.equals(this.getReferenceNode())) {
            return;
        }
        this.referenceNode = refNode;
        this.updateTagLibs();
    }

    public void setDocument(IDocument iDocument, Node refNode) {
        this.iDocument = iDocument;
        if (refNode != null) {
            this.referenceNode = null;
            this.setReferenceNode(refNode);
        } else {
            List<TaglibData> taglibs = this.getIncludeTaglibs();
            if (taglibs != null) {
                this.setTaglibs(taglibs);
            }
        }
    }

    public void collectRefNodeTagLibs() {
        if (this.getReferenceNode() == null) {
            return;
        }
        if (this.getReferenceNode().getNodeType() == 9) {
            NodeList nodes = this.getReferenceNode().getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                List<TaglibData> result = XmlUtil.processNode(node, this.getIncludeTaglibs());
                if (result != null && result.size() > 0) {
                    this.setTaglibs(result);
                    break;
                }
                ++i;
            }
        } else {
            this.setTaglibs(XmlUtil.processNode(this.getReferenceNode(), this.getIncludeTaglibs()));
        }
    }

    public void updateTagLibs() {
        this.collectRefNodeTagLibs();
    }

    @Override
    public void refreshBundleValues() {
        this.updateTagLibs();
    }

    public List<TaglibData> getTagLibs() {
        ArrayList<TaglibData> clone = new ArrayList<TaglibData>();
        for (TaglibData taglib : this.getTaglibs()) {
            clone.add(taglib);
        }
        return clone;
    }

    public void addTaglibListener(VpeTaglibListener listener) {
    }

    public void removeTaglibListener(VpeTaglibListener listener) {
    }

    private List<TaglibData> getTaglibs() {
        if (this.taglibs == null) {
            this.taglibs = new ArrayList<TaglibData>();
        }
        return this.taglibs;
    }

    private void setTaglibs(List<TaglibData> taglibs) {
        this.taglibs = taglibs;
    }

    public Node getReferenceNode() {
        return this.referenceNode;
    }

    private IVisualContext getPageContext() {
        return this.pageContext;
    }

    private void setPageContext(IVisualContext pageContext) {
        this.pageContext = pageContext;
    }

    @Override
    public List<TaglibData> getIncludeTaglibs() {
        List<TaglibData> result = null;
        result = this.getPageContext() != null ? this.getPageContext().getIncludeTaglibs() : new ArrayList<TaglibData>();
        if (this.iDocument != null) {
            result = XmlUtil.getTaglibsForJSPDocument(this.iDocument, result);
        }
        return result;
    }
}

