/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.editor.jspeditor.info;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.sse.ui.internal.derived.HTML2TextReader;
import org.eclipse.wst.sse.ui.internal.derived.HTMLTextPresenter;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.jboss.tools.common.el.core.model.ELExpression;
import org.jboss.tools.common.el.core.model.ELInstance;
import org.jboss.tools.common.el.core.model.ELInvocationExpression;
import org.jboss.tools.common.el.core.model.ELModel;
import org.jboss.tools.common.el.core.model.ELUtil;
import org.jboss.tools.common.el.core.parser.ELParser;
import org.jboss.tools.common.el.core.parser.ELParserUtil;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.common.el.core.resolver.ELResolution;
import org.jboss.tools.common.el.core.resolver.ELResolver;
import org.jboss.tools.common.el.core.resolver.ELSegment;
import org.jboss.tools.common.el.core.resolver.JavaMemberELSegmentImpl;
import org.jboss.tools.common.el.ui.ca.ELProposalProcessor;
import org.jboss.tools.common.el.ui.internal.info.ELBrowserInformationControlInput;
import org.jboss.tools.common.el.ui.internal.info.ELInfoHover;
import org.jboss.tools.common.text.TextProposal;
import org.jboss.tools.common.util.StringUtil;
import org.jboss.tools.jst.web.kb.IPageContext;
import org.jboss.tools.jst.web.kb.KbQuery;
import org.jboss.tools.jst.web.kb.PageContextFactory;
import org.jboss.tools.jst.web.kb.PageProcessor;
import org.jboss.tools.jst.web.kb.el.MessagePropertyELSegmentImpl;
import org.jboss.tools.jst.web.kb.taglib.INameSpace;
import org.jboss.tools.jst.web.ui.internal.editor.contentassist.ELPrefixUtils;
import org.jboss.tools.jst.web.ui.internal.editor.contentassist.Utils;
import org.w3c.dom.Node;

public class FaceletTagInfoHoverProcessor
extends ELInfoHover {
    private ELContext fContext;
    private int fDocumentPosition;
    private static final String EMPTY_STRING = "";

    protected String computeHoverHelp(ITextViewer textViewer, int documentPosition) {
        this.fDocumentPosition = documentPosition;
        this.fContext = null;
        this.fContext = PageContextFactory.createPageContext((IDocument)textViewer.getDocument());
        if (this.fContext == null) {
            return null;
        }
        IStructuredDocumentRegion flatNode = ((IStructuredDocument)textViewer.getDocument()).getRegionAtCharacterOffset(this.fDocumentPosition);
        ITextRegion region = null;
        if (flatNode != null) {
            region = flatNode.getRegionAtCharacterOffset(this.fDocumentPosition);
        }
        String hoverHelp = null;
        if (region != null) {
            ELPrefixUtils.ELTextRegion elPrefix = this.getELPrefix(flatNode, region, this.fDocumentPosition);
            ELInvocationExpression elOperand = this.getELExpression(flatNode, region, this.fDocumentPosition);
            if (elPrefix != null && elPrefix.isELStarted() && elOperand != null) {
                IndexedRegion treeNode = ContentAssistUtils.getNodeAt((ITextViewer)textViewer, (int)this.fDocumentPosition);
                if (treeNode == null) {
                    return null;
                }
                Node node = (Node)treeNode;
                while (node != null && node.getNodeType() == 3 && node.getParentNode() != null) {
                    node = node.getParentNode();
                }
                return this.computeELHelp((IDOMNode)treeNode, (IDOMNode)node, flatNode, region, elOperand);
            }
        }
        return hoverHelp != null ? hoverHelp : super.computeHoverHelp(textViewer, documentPosition);
    }

    protected String computeTagAttNameHelp(IDOMNode xmlnode, IDOMNode parentNode, IStructuredDocumentRegion flatNode, ITextRegion region) {
        if (this.fContext == null) {
            return null;
        }
        String tagName = Utils.getTagName((Node)xmlnode, true);
        String query = flatNode.getText(region);
        String prefix = this.getPrefix(tagName);
        String uri = this.getUri(prefix);
        String[] parentTags = Utils.getParentTags(xmlnode, true, true);
        String parent = Utils.getParent(xmlnode, true, true, true);
        KbQuery kbQuery = Utils.createKbQuery(KbQuery.Type.ATTRIBUTE_NAME, this.fDocumentPosition, query, query, prefix, uri, parentTags, parent, false);
        TextProposal[] proposals = PageProcessor.getInstance().getProposals(kbQuery, this.fContext);
        if (proposals == null) {
            return null;
        }
        TextProposal[] textProposalArray = proposals;
        int n = proposals.length;
        int n2 = 0;
        while (n2 < n) {
            TextProposal proposal = textProposalArray[n2];
            if (proposal != null && proposal.getContextInfo() != null && proposal.getContextInfo().trim().length() > 0) {
                return proposal.getContextInfo();
            }
            ++n2;
        }
        return null;
    }

    protected String computeTagAttValueHelp(IDOMNode xmlnode, IDOMNode parentNode, IStructuredDocumentRegion flatNode, ITextRegion region) {
        return null;
    }

    protected String computeTagNameHelp(IDOMNode xmlnode, IDOMNode parentNode, IStructuredDocumentRegion flatNode, ITextRegion region) {
        if (this.fContext == null) {
            return null;
        }
        String query = Utils.getTagName((Node)xmlnode, true);
        String prefix = this.getPrefix(query);
        String uri = this.getUri(prefix);
        String[] parentTags = Utils.getParentTags(xmlnode, false, true);
        String parent = Utils.getParent(xmlnode, false, false, true);
        KbQuery kbQuery = Utils.createKbQuery(KbQuery.Type.TAG_NAME, this.fDocumentPosition, query, "<" + query, prefix, uri, parentTags, parent, false);
        TextProposal[] proposals = PageProcessor.getInstance().getProposals(kbQuery, this.fContext);
        if (proposals == null) {
            return null;
        }
        TextProposal[] textProposalArray = proposals;
        int n = proposals.length;
        int n2 = 0;
        while (n2 < n) {
            TextProposal proposal = textProposalArray[n2];
            if (proposal != null && proposal.getContextInfo() != null && proposal.getContextInfo().trim().length() > 0) {
                return proposal.getContextInfo();
            }
            ++n2;
        }
        return null;
    }

    protected String computeELHelp(IDOMNode xmlnode, IDOMNode parentNode, IStructuredDocumentRegion flatNode, ITextRegion region, ELInvocationExpression elOperand) {
        if (this.fContext == null) {
            return null;
        }
        ELResolver[] resolvers = this.fContext.getElResolvers();
        int i = 0;
        while (resolvers != null && i < resolvers.length) {
            block6: {
                ELSegment segment;
                block7: {
                    IJavaElement[] javaElements;
                    block8: {
                        ELResolution resolution;
                        ELResolution eLResolution = resolution = resolvers[i] == null ? null : resolvers[i].resolve(this.fContext, (ELExpression)elOperand, this.fDocumentPosition);
                        if (resolution == null || !resolution.isResolved()) break block6;
                        segment = resolution.getLastSegment();
                        if (!(segment instanceof JavaMemberELSegmentImpl)) break block7;
                        JavaMemberELSegmentImpl jmSegment = (JavaMemberELSegmentImpl)segment;
                        javaElements = jmSegment.getAllJavaElements();
                        if (javaElements != null && javaElements.length != 0) break block8;
                        if (jmSegment.getJavaElement() == null) break block6;
                        javaElements = new IJavaElement[]{jmSegment.getJavaElement()};
                    }
                    if (javaElements != null && javaElements.length != 0) {
                        Arrays.sort(javaElements, ELProposalProcessor.CASE_INSENSITIVE_ORDER);
                        ELBrowserInformationControlInput hover = (ELBrowserInformationControlInput)ELInfoHover.getHoverInfo((IJavaElement[])javaElements, null);
                        return hover == null ? null : hover.getHtml();
                    }
                    break block6;
                }
                if (segment instanceof MessagePropertyELSegmentImpl) {
                    MessagePropertyELSegmentImpl mpSegment = (MessagePropertyELSegmentImpl)segment;
                    String baseName = mpSegment.getBaseName();
                    String propertyName = mpSegment.isBundle() ? null : StringUtil.trimQuotes((String)segment.getToken().getText());
                    ELBrowserInformationControlInput hover = (ELBrowserInformationControlInput)ELInfoHover.getHoverInfo((String)baseName, (String)propertyName, (Object)mpSegment.getObjects(), null);
                    return hover == null ? null : hover.getHtml();
                }
            }
            ++i;
        }
        return null;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        ELPrefixUtils.ELTextRegion elPrefix;
        String regionType;
        if (textViewer == null || textViewer.getDocument() == null) {
            return null;
        }
        IStructuredDocumentRegion flatNode = ((IStructuredDocument)textViewer.getDocument()).getRegionAtCharacterOffset(offset);
        ITextRegion region = null;
        if (flatNode != null) {
            region = flatNode.getRegionAtCharacterOffset(offset);
        }
        if (region != null && ("XML_CONTENT".equals(regionType = region.getType()) || "BLOCK_TEXT".equals(regionType) || "XML_TAG_ATTRIBUTE_VALUE".equals(regionType)) && (elPrefix = this.getELPrefix(flatNode, region, offset)) != null && elPrefix.isELStarted()) {
            return new Region(elPrefix.getStartOffset() + elPrefix.getOffset() + elPrefix.getLength(), 0);
        }
        return super.getHoverRegion(textViewer, offset);
    }

    protected IFile getResource(IDocument document) {
        IStructuredModel sModel = StructuredModelManager.getModelManager().getExistingModelForRead(document);
        try {
            if (sModel != null) {
                String baseLocation = sModel.getBaseLocation();
                IPath location = new Path(baseLocation).makeAbsolute();
                IFile iFile = FileBuffers.getWorkspaceFileAtLocation((IPath)location);
                return iFile;
            }
        }
        finally {
            if (sModel != null) {
                sModel.releaseFromRead();
            }
        }
        return null;
    }

    private String getPrefix(String tagname) {
        int index;
        String prefix = null;
        int n = index = tagname == null ? -1 : tagname.indexOf(58);
        if (tagname != null && index != -1) {
            prefix = tagname.substring(0, index);
        }
        if (prefix != null) {
            return prefix;
        }
        String uri = this.getUri(EMPTY_STRING);
        return uri == null ? null : EMPTY_STRING;
    }

    private String getUri(String prefix) {
        if (prefix == null || this.fContext == null) {
            return null;
        }
        if (!(this.fContext instanceof IPageContext)) {
            return null;
        }
        Map nameSpaces = ((IPageContext)this.fContext).getNameSpaces(this.fDocumentPosition);
        if (nameSpaces == null || nameSpaces.isEmpty()) {
            return null;
        }
        for (List nameSpace : nameSpaces.values()) {
            for (INameSpace n : nameSpace) {
                if (!prefix.equals(n.getPrefix())) continue;
                return n.getURI();
            }
        }
        return null;
    }

    private ELPrefixUtils.ELTextRegion getELPrefix(IStructuredDocumentRegion sdRegion, ITextRegion region, int offset) {
        if (sdRegion == null || region == null) {
            return null;
        }
        String text = sdRegion.getFullText(region);
        int startOffset = sdRegion.getStartOffset() + region.getStart();
        boolean isAttributeValue = false;
        boolean hasOpenQuote = false;
        boolean hasCloseQuote = false;
        char quoteChar = '\u0000';
        if ("XML_TAG_ATTRIBUTE_VALUE".equals(region.getType())) {
            isAttributeValue = true;
            if (text.startsWith("\"") || text.startsWith("'")) {
                quoteChar = text.charAt(0);
                hasOpenQuote = true;
            }
            if (hasOpenQuote && text.endsWith(String.valueOf(quoteChar))) {
                hasCloseQuote = true;
            }
        }
        int inValueOffset = offset - startOffset;
        if (text != null && text.length() < inValueOffset) {
            return null;
        }
        if (inValueOffset < 0) {
            return null;
        }
        ELParser p = ELParserUtil.getJbossFactory().createParser();
        ELModel model = p.parse(text);
        ELInstance is = ELUtil.findInstance((ELModel)model, (int)inValueOffset);
        ELInvocationExpression ie = ELUtil.findExpression((ELModel)model, (int)inValueOffset);
        boolean isELStarted = model != null && is != null && (model.toString().startsWith("#{") || model.toString().startsWith("${"));
        boolean isELClosed = model != null && is != null && model.toString().endsWith("}");
        ELPrefixUtils.ELTextRegion tr = new ELPrefixUtils.ELTextRegion(startOffset, ie == null ? inValueOffset : ie.getStartPosition(), ie == null ? 0 : ie.getLength(), ie == null ? EMPTY_STRING : ie.getText(), isELStarted, isELClosed, isAttributeValue, hasOpenQuote, hasCloseQuote, quoteChar);
        return tr;
    }

    private ELInvocationExpression getELExpression(IStructuredDocumentRegion sdRegion, ITextRegion region, int offset) {
        if (sdRegion == null || region == null) {
            return null;
        }
        String text = sdRegion.getFullText(region);
        int startOffset = sdRegion.getStartOffset() + region.getStart();
        int inValueOffset = offset - startOffset;
        if (text != null && text.length() < inValueOffset) {
            return null;
        }
        if (inValueOffset < 0) {
            return null;
        }
        ELParser p = ELParserUtil.getJbossFactory().createParser();
        ELModel model = p.parse(text);
        ELInvocationExpression ie = ELUtil.findExpression((ELModel)model, (int)inValueOffset);
        return ie;
    }

    public IInformationControlCreator getHoverControlCreator1() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true){

                    protected Reader createReader(String hoverInfo, TextPresentation presentation) {
                        return new HTML2TextReader(new StringReader(hoverInfo), presentation){

                            protected String computeSubstitution(int c) throws IOException {
                                String substitution = super.computeSubstitution(c);
                                if (substitution != null && substitution.length() > 0 && substitution.startsWith("<") && substitution.endsWith(">")) {
                                    return FaceletTagInfoHoverProcessor.EMPTY_STRING;
                                }
                                return substitution;
                            }
                        };
                    }
                });
            }
        };
    }
}

