/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.editor.outline;

import java.util.Properties;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.model.ui.wizards.query.AbstractQueryWizardView;
import org.jboss.tools.jst.web.kb.IPageContext;
import org.jboss.tools.jst.web.kb.KbQuery;
import org.jboss.tools.jst.web.ui.internal.editor.drop.treeviewer.model.IAttributeValue;
import org.jboss.tools.jst.web.ui.internal.editor.drop.treeviewer.model.IAttributeValueContainer;
import org.jboss.tools.jst.web.ui.internal.editor.drop.treeviewer.model.ModelElement;
import org.jboss.tools.jst.web.ui.internal.editor.drop.treeviewer.ui.AttributeValueContentProvider;
import org.jboss.tools.jst.web.ui.internal.editor.drop.treeviewer.ui.AttributeValueLabelProvider;
import org.jboss.tools.jst.web.ui.internal.editor.drop.treeviewer.ui.AttributeValueSorter;
import org.jboss.tools.jst.web.ui.internal.editor.outline.JSPTreeMenuInvoker;
import org.jboss.tools.jst.web.ui.internal.editor.outline.ValueHelper;

class JSPTreeDialogView
extends AbstractQueryWizardView {
    protected TreeViewer treeViewer;
    protected AttributeValueLabelProvider labelProvider;
    AttributeValueContentProvider contentProvider;
    Properties context;
    ModelElement root;

    JSPTreeDialogView() {
    }

    public void setObject(Object object) {
        this.context = this.findProperties(object);
    }

    public Control createControl(Composite parent) {
        GridLayout layout = new GridLayout(1, false);
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 2;
        parent.setLayout((Layout)layout);
        this.treeViewer = new TreeViewer(parent);
        this.labelProvider = new AttributeValueLabelProvider();
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.contentProvider = new AttributeValueContentProvider();
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setUseHashlookup(true);
        GridData layoutData = new GridData(1808);
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        this.treeViewer.getControl().setLayoutData((Object)layoutData);
        String query = this.context.getProperty("query");
        IPageContext pageContext = (IPageContext)this.context.get("pageContext");
        KbQuery kbQuery = (KbQuery)this.context.get("kbQuery");
        ValueHelper valueHelper = new ValueHelper();
        this.root = valueHelper.getInitalInput(pageContext, kbQuery);
        this.treeViewer.setInput((Object)this.root);
        this.treeViewer.setSorter((ViewerSorter)new AttributeValueSorter());
        this.getCommandBar().setEnabled(OK, false);
        JSPTreeMenuInvoker menuInvoker = new JSPTreeMenuInvoker();
        menuInvoker.setViewer(this.treeViewer);
        menuInvoker.setContext(this.context);
        this.treeViewer.getTree().addMouseListener((MouseListener)menuInvoker);
        ModelElement initialSelection = this.getInitialSelection();
        if (initialSelection != null) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)initialSelection), true);
        }
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selected;
                ISelection selection = event.getSelection();
                String value = null;
                if (!selection.isEmpty() && selection instanceof StructuredSelection && (selected = ((StructuredSelection)selection).getFirstElement()) instanceof IAttributeValue) {
                    value = ((IAttributeValue)selected).getValue();
                }
                JSPTreeDialogView.this.getCommandBar().setEnabled(OK, value != null);
                if (value == null) {
                    JSPTreeDialogView.this.context.remove("value");
                } else {
                    JSPTreeDialogView.this.context.setProperty("value", value);
                }
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (JSPTreeDialogView.this.getCommandBar().isEnabled(OK)) {
                    JSPTreeDialogView.this.action(OK);
                }
            }
        });
        return this.treeViewer.getControl();
    }

    private ModelElement getInitialSelection() {
        String value = this.context.getProperty("value");
        if (value == null || value.length() == 0 || value.equals("#{") || value.equals("#{}")) {
            ModelElement[] cs = ((IAttributeValueContainer)((Object)this.root)).getChildren();
            return cs.length == 0 ? this.root : cs[0];
        }
        return this.matchChildren(this.root, value, -2147483646);
    }

    private ModelElement matchChildren(Object current, String value, int dv) {
        if (!(current instanceof IAttributeValueContainer)) {
            return (ModelElement)current;
        }
        Object[] cs = this.contentProvider.getChildren(current);
        ModelElement best = null;
        int i = cs.length - 1;
        while (i >= 0 && dv != 0) {
            ModelElement m = (ModelElement)cs[i];
            int v = m.compareValue(value);
            if (v == 0) {
                return m;
            }
            if (v != Integer.MAX_VALUE && this.isBetter(v, dv)) {
                best = v < 0 ? m : this.matchChildren(m, value, dv);
                dv = best == cs[i] ? v : best.compareValue(value);
            }
            --i;
        }
        if (best != null) {
            return best;
        }
        return (ModelElement)current;
    }

    boolean isBetter(int v, int dv) {
        if (v == 0) {
            return true;
        }
        if (v < 0 && dv < 0) {
            return true;
        }
        if (v < 0 && dv > 0) {
            return true;
        }
        if (v > 0 && dv > 0) {
            return v <= dv;
        }
        return v > 0 && dv < -1000;
    }
}

