/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.preferences.js;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.common.ui.widget.editor.SwtFieldEditorFactory;
import org.jboss.tools.jst.web.ui.internal.preferences.js.JSCSSPreferencePage;
import org.jboss.tools.jst.web.ui.internal.preferences.js.JSLib;
import org.jboss.tools.jst.web.ui.internal.preferences.js.JSLibFactory;
import org.jboss.tools.jst.web.ui.internal.preferences.js.JSLibModel;
import org.jboss.tools.jst.web.ui.internal.preferences.js.JSLibVersion;
import org.jboss.tools.jst.web.ui.internal.preferences.js.TitledDialog;
import org.jboss.tools.jst.web.ui.palette.html.wizard.WizardMessages;

class AbstractJSLibDialog
extends TitledDialog {
    JSLibVersion current = null;
    IFieldEditor nameEditor;
    IFieldEditor versionEditor;

    public String getName() {
        return this.nameEditor.getValueAsString();
    }

    public String getVersion() {
        return this.versionEditor.getValueAsString();
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(dialogArea, 0);
        GridLayout layout = new GridLayout(3, false);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        AbstractJSLibDialog.applyDialogFont((Control)composite);
        this.nameEditor = this.createNameEditor();
        this.nameEditor.doFillIntoGrid((Object)composite);
        JSCSSPreferencePage.expandCombo(this.nameEditor);
        this.nameEditor.addPropertyChangeListener((PropertyChangeListener)this);
        this.versionEditor = this.createVersionEditor();
        this.versionEditor.doFillIntoGrid((Object)composite);
        this.versionEditor.addPropertyChangeListener((PropertyChangeListener)this);
        return dialogArea;
    }

    IFieldEditor createNameEditor() {
        List<String> availableNames = this.getAvailableNames();
        return SwtFieldEditorFactory.INSTANCE.createComboEditor("name", WizardMessages.nameLabel, availableNames, (Object)(this.current == null ? "" : this.current.getLib().getName()), true, "Type a new name or select any existing one");
    }

    IFieldEditor createVersionEditor() {
        return SwtFieldEditorFactory.INSTANCE.createTextEditor("version", WizardMessages.jsLibVersionLabel, this.current == null ? "" : this.current.getVersion());
    }

    List<String> getAvailableNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (JSLib lib : JSLibFactory.getInstance().getWorkingCopy().getLibs()) {
            result.add(lib.getName());
        }
        return result;
    }

    @Override
    protected void validate() {
        JSLibModel model;
        boolean enabled;
        String v = this.getVersion();
        String n = this.getName();
        boolean bl = enabled = v.length() > 0 && n.length() > 0;
        if (enabled && (model = JSLibFactory.getInstance().getWorkingCopy()).getLib(n) != null && model.getLib(n).getVersion(v) != null) {
            enabled = false;
        }
        this.getButton(0).setEnabled(enabled);
    }
}

