/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.preferences.js;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.jst.web.ui.internal.preferences.js.AddFileRefDialog;
import org.jboss.tools.jst.web.ui.internal.preferences.js.DefaultSelectionListener;
import org.jboss.tools.jst.web.ui.internal.preferences.js.EditFileRefDialog;
import org.jboss.tools.jst.web.ui.internal.preferences.js.EditJSLibDialog;
import org.jboss.tools.jst.web.ui.internal.preferences.js.JSLib;
import org.jboss.tools.jst.web.ui.internal.preferences.js.JSLibFactory;
import org.jboss.tools.jst.web.ui.internal.preferences.js.JSLibModel;
import org.jboss.tools.jst.web.ui.internal.preferences.js.JSLibVersion;
import org.jboss.tools.jst.web.ui.internal.preferences.js.LibsContentProvider;
import org.jboss.tools.jst.web.ui.internal.preferences.js.LibsLabelProvider;
import org.jboss.tools.jst.web.ui.internal.preferences.js.NewJSLibDialog;
import org.jboss.tools.jst.web.ui.internal.preferences.js.URLWrapper;
import org.jboss.tools.jst.web.ui.palette.html.wizard.WizardMessages;

public class JSCSSPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.jboss.tools.jst.web.ui.JSCSSPreferencePage";
    JSLibModel model;
    TreeViewer tree;
    Button editButton;
    Button addJSButton;
    Button removeButton;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        this.model = JSLibFactory.getInstance().getWorkingCopy();
        Composite libs = new Composite(parent, 0);
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        libs.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        libs.setLayout((Layout)layout);
        int heightHint = this.convertVerticalDLUsToPixels(14);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        Group gd = new Group(libs, 0);
        gd.setText(WizardMessages.descriptionLabel);
        GridData dl = new GridData(768);
        gd.setLayoutData((Object)dl);
        gd.setLayout((Layout)new GridLayout());
        Label label = new Label((Composite)gd, 0);
        label.setLayoutData((Object)new GridData(768));
        label.setText(WizardMessages.configureJSCSSDescription);
        Group gt = new Group(libs, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        gt.setLayout((Layout)layout);
        gt.setLayoutData((Object)new GridData(1808));
        gt.setText(WizardMessages.JSCSSReferencesLabel);
        this.tree = new TreeViewer((Composite)gt);
        this.tree.setAutoExpandLevel(2);
        this.tree.getControl().setLayoutData((Object)new GridData(1808));
        LibsContentProvider contentProvider = new LibsContentProvider();
        this.tree.setContentProvider((IContentProvider)contentProvider);
        LibsLabelProvider labelProvider = new LibsLabelProvider();
        this.tree.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.tree.setInput((Object)this.model);
        this.tree.addSelectionChangedListener((ISelectionChangedListener)new SL());
        Composite buttons = new Composite((Composite)gt, 0);
        GridData db = new GridData(1041);
        buttons.setLayoutData((Object)db);
        GridLayout l = new GridLayout();
        l.marginTop = 0;
        l.marginHeight = 0;
        buttons.setLayout((Layout)l);
        Button newButton = new Button(buttons, 8);
        newButton.setText(WizardMessages.newButtonLabel);
        GridData d = new GridData(1);
        d.widthHint = widthHint;
        d.heightHint = heightHint;
        newButton.setLayoutData((Object)d);
        this.editButton = new Button(buttons, 8);
        this.editButton.setText(WizardMessages.editButtonLabel);
        d = new GridData(1);
        d.widthHint = widthHint;
        d.heightHint = heightHint;
        this.editButton.setLayoutData((Object)d);
        this.addJSButton = new Button(buttons, 8);
        this.addJSButton.setText(WizardMessages.addJSCSSButtonLabel);
        d = new GridData(1);
        d.widthHint = widthHint;
        d.heightHint = heightHint;
        this.addJSButton.setLayoutData((Object)d);
        this.removeButton = new Button(buttons, 8);
        this.removeButton.setText(WizardMessages.removeActionLabel);
        d = new GridData(1);
        d.widthHint = widthHint;
        d.heightHint = heightHint;
        this.removeButton.setLayoutData((Object)d);
        newButton.addSelectionListener((SelectionListener)new DefaultSelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NewJSLibDialog dialog = new NewJSLibDialog();
                int result = dialog.open();
                if (result == 0) {
                    JSLib lib = JSCSSPreferencePage.this.model.getOrCreateLib(dialog.getName());
                    lib.getOrCreateVersion(dialog.getVersion());
                    JSCSSPreferencePage.this.refreshTree();
                }
            }
        });
        this.editButton.addSelectionListener((SelectionListener)new DefaultSelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                URLWrapper w;
                EditFileRefDialog dialog;
                int result;
                Object s = JSCSSPreferencePage.this.getSelectedObject();
                if (s instanceof JSLibVersion) {
                    JSLibVersion v = (JSLibVersion)s;
                    EditJSLibDialog dialog2 = new EditJSLibDialog(v);
                    int result2 = dialog2.open();
                    if (result2 == 0) {
                        if (v.getLib().getName().equals(dialog2.getName())) {
                            v.getLib().removeVersion(v);
                            v.setVersion(dialog2.getVersion());
                            v.getLib().addVersion(v);
                        } else {
                            v.getLib().removeVersion(v);
                            JSLib lib = JSCSSPreferencePage.this.model.getOrCreateLib(dialog2.getName());
                            lib.addVersion(v);
                        }
                        JSCSSPreferencePage.this.refreshTree();
                    }
                } else if (s instanceof URLWrapper && (result = (dialog = new EditFileRefDialog(w.parent, w = (URLWrapper)s)).open()) == 0) {
                    w.parent.getURLs().remove(w.url);
                    w.parent.getURLs().add(dialog.getURL());
                    JSCSSPreferencePage.this.refreshTree();
                }
            }
        });
        this.addJSButton.addSelectionListener((SelectionListener)new DefaultSelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AddFileRefDialog dialog;
                int result;
                Object s = JSCSSPreferencePage.this.getSelectedObject();
                JSLibVersion v = null;
                if (s instanceof JSLibVersion) {
                    v = (JSLibVersion)s;
                } else if (s instanceof URLWrapper) {
                    v = ((URLWrapper)s).parent;
                }
                if (v != null && (result = (dialog = new AddFileRefDialog(v)).open()) == 0) {
                    v.getURLs().add(dialog.getURL());
                    JSCSSPreferencePage.this.refreshTree();
                }
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new DefaultSelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Object s = JSCSSPreferencePage.this.getSelectedObject();
                if (s instanceof JSLibVersion) {
                    JSLibVersion v = (JSLibVersion)s;
                    JSLib lib = v.getLib();
                    lib.removeVersion(v);
                    if (lib.getVersions().isEmpty()) {
                        JSCSSPreferencePage.this.model.removeLib(lib);
                    }
                    JSCSSPreferencePage.this.refreshTree();
                } else if (s instanceof URLWrapper) {
                    URLWrapper w = (URLWrapper)s;
                    w.parent.getURLs().remove(w.url);
                    JSCSSPreferencePage.this.refreshTree();
                }
            }
        });
        this.updateButtons();
        return libs;
    }

    Object getSelectedObject() {
        ISelection s = this.tree.getSelection();
        if (s.isEmpty()) {
            return null;
        }
        if (s instanceof IStructuredSelection) {
            return ((IStructuredSelection)s).getFirstElement();
        }
        return null;
    }

    void refreshTree() {
        if (this.tree.getControl() != null && !this.tree.getControl().isDisposed()) {
            this.tree.refresh();
        }
    }

    protected void performDefaults() {
        JSLibFactory.getInstance().applyDefault();
        this.refreshTree();
    }

    protected void performApply() {
        JSLibFactory.getInstance().applyWorkingCopy();
    }

    public boolean performOk() {
        JSLibFactory.getInstance().applyWorkingCopy();
        JSLibFactory.getInstance().disposeWorkingCopy();
        JSLibFactory.getInstance().savePreferenceModel();
        return true;
    }

    public boolean performCancel() {
        JSLibFactory.getInstance().disposeWorkingCopy();
        return true;
    }

    public static void expandCombo(IFieldEditor editor) {
        Control c = (Control)editor.getEditorControls()[1];
        GridData d = (GridData)c.getLayoutData();
        d.horizontalAlignment = 4;
        d.grabExcessHorizontalSpace = true;
        c.setLayoutData((Object)d);
    }

    void updateButtons() {
        if (this.tree == null || this.tree.getControl().isDisposed()) {
            return;
        }
        ISelection s = this.tree.getSelection();
        boolean isEnabled = !s.isEmpty();
        this.addJSButton.setEnabled(isEnabled);
        this.editButton.setEnabled(isEnabled);
        this.removeButton.setEnabled(isEnabled);
    }

    class SL
    implements ISelectionChangedListener {
        SL() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            JSCSSPreferencePage.this.updateButtons();
        }
    }
}

