/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.preferences.js;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.jboss.tools.jst.web.ui.internal.preferences.js.JSLibVersion;

public class JSLib {
    String name;
    Map<String, JSLibVersion> versions = new TreeMap<String, JSLibVersion>();
    static VersionComparator versionComparator = new VersionComparator();
    static VersionStringComparator versionStringComparator = new VersionStringComparator();

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Collection<JSLibVersion> getVersions() {
        return this.versions.values();
    }

    public JSLibVersion[] getSortedVersions() {
        JSLibVersion[] vs = this.versions.values().toArray(new JSLibVersion[0]);
        Arrays.sort(vs, versionComparator);
        return vs;
    }

    public Collection<String> getVersionNames() {
        String[] vs = this.versions.keySet().toArray(new String[0]);
        Arrays.sort(vs, versionStringComparator);
        ArrayList<String> result = new ArrayList<String>();
        String[] stringArray = vs;
        int n = vs.length;
        int n2 = 0;
        while (n2 < n) {
            String v = stringArray[n2];
            result.add(v);
            ++n2;
        }
        return result;
    }

    public JSLibVersion getVersion(String version) {
        return this.versions.get(version);
    }

    public JSLibVersion getOrCreateVersion(String version) {
        JSLibVersion v = this.getVersion(version);
        if (version != null) {
            v = new JSLibVersion(this);
            v.setVersion(version);
            this.addVersion(v);
        }
        return v;
    }

    public void addVersion(JSLibVersion version) {
        this.versions.put(version.getVersion(), version);
        version.lib = this;
    }

    public boolean removeVersion(JSLibVersion version) {
        return this.versions.remove(version.getVersion()) != null;
    }

    public void applyWorkingCopy(JSLib copy, boolean applyRemoved) {
        this.name = copy.name;
        if (applyRemoved) {
            Iterator<String> vs = this.versions.keySet().iterator();
            while (vs.hasNext()) {
                if (copy.getVersion(vs.next()) != null) continue;
                vs.remove();
            }
        }
        for (JSLibVersion vc : copy.getVersions()) {
            JSLibVersion vo = this.getVersion(vc.getVersion());
            if (vo == null) {
                this.addVersion(vc);
                continue;
            }
            vo.applyWorkingCopy(vc, applyRemoved);
        }
    }

    public boolean equals(JSLib other) {
        if (!this.name.equals(other.name) || this.versions.size() != other.versions.size()) {
            return false;
        }
        for (JSLibVersion version : this.versions.values()) {
            JSLibVersion otherVersion = other.versions.get(version.getVersion());
            if (otherVersion != null && version.equals(otherVersion)) continue;
            return false;
        }
        return true;
    }

    static class VersionComparator
    implements Comparator<JSLibVersion> {
        VersionComparator() {
        }

        @Override
        public int compare(JSLibVersion o1, JSLibVersion o2) {
            return versionStringComparator.compare(o1.getVersion(), o2.getVersion());
        }
    }

    static class VersionStringComparator
    implements Comparator<String> {
        VersionStringComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            StringTokenizer s1 = new StringTokenizer(o1, ".");
            StringTokenizer s2 = new StringTokenizer(o2, ".");
            while (s1.hasMoreTokens() && s2.hasMoreTokens()) {
                String t2;
                String t1 = s1.nextToken();
                if (t1.equals(t2 = s2.nextToken())) continue;
                if (t1.length() != t2.length()) {
                    return t1.length() - t2.length();
                }
                return t1.compareTo(t2);
            }
            return 0;
        }
    }
}

