/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.preferences.js;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.jboss.tools.jst.web.ui.internal.preferences.js.JSLib;
import org.jboss.tools.jst.web.ui.internal.preferences.js.JSLibModel;
import org.jboss.tools.jst.web.ui.internal.preferences.js.JSLibVersion;
import org.jboss.tools.jst.web.ui.internal.preferences.js.URLWrapper;

class LibsContentProvider
implements ITreeContentProvider {
    JSLibModel model;
    Map<String, URLWrapper> urls = new HashMap<String, URLWrapper>();

    public void dispose() {
        this.urls.clear();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.model = (JSLibModel)newInput;
        if (viewer != null && this.model != null && viewer.getControl() != null && !viewer.getControl().isDisposed()) {
            viewer.refresh();
        }
    }

    public Object[] getElements(Object inputElement) {
        ArrayList<JSLibVersion> versions = new ArrayList<JSLibVersion>();
        if (this.model != null) {
            JSLib[] jSLibArray = this.model.getSortedLibs();
            int n = jSLibArray.length;
            int n2 = 0;
            while (n2 < n) {
                JSLib lib = jSLibArray[n2];
                JSLibVersion[] jSLibVersionArray = lib.getSortedVersions();
                int n3 = jSLibVersionArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    JSLibVersion v = jSLibVersionArray[n4];
                    versions.add(v);
                    ++n4;
                }
                ++n2;
            }
        }
        return versions.toArray();
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof JSLibVersion) {
            ArrayList<URLWrapper> result = new ArrayList<URLWrapper>();
            JSLibVersion v = (JSLibVersion)parentElement;
            String[] stringArray = v.getSortedUrls();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                URLWrapper w = this.urls.get(s);
                if (w == null) {
                    w = new URLWrapper(s, v);
                    this.urls.put(s, w);
                } else {
                    w.parent = v;
                    w.url = s;
                }
                result.add(w);
                ++n2;
            }
            return result.toArray();
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof URLWrapper) {
            return ((URLWrapper)element).parent;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof JSLibVersion;
    }
}

