/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.properties.html;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.jboss.tools.common.ui.CommonUIMessages;
import org.jboss.tools.common.ui.widget.editor.ButtonFieldEditor;
import org.jboss.tools.common.ui.widget.editor.CompositeEditor;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.common.ui.widget.editor.LabelFieldEditor;
import org.jboss.tools.common.ui.widget.editor.SwtFieldEditorFactory;
import org.jboss.tools.common.ui.widget.editor.TextFieldEditor;
import org.jboss.tools.jst.web.html.HTMLConstants;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.JQueryFieldEditorFactory;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.WizardDescriptions;
import org.jboss.tools.jst.web.ui.palette.html.wizard.WizardMessages;

public class HTMLFieldEditorFactory
implements HTMLConstants {
    static String[] BORDER_VALUES = new String[]{"", "1"};
    static String[] CHARSET_LIST = new String[]{"", "UTF-8", "ISO-8859-1"};
    static String[] DIR_LIST = new String[]{"ltr", "rtl"};
    static String[] HTTP_EQUIV_VALUES = new String[]{"", "content-type", "default-style", "refresh"};
    static String[] KEYTYPE_VALUES = new String[]{"", "rsa", "dsa", "ec"};
    static String[] KIND_VALUES = new String[]{"", "captions", "chapters", "descriptions", "metadata", "subtitles"};
    static String[] META_NAME_VALUES = new String[]{"", "application-name", "author", "description", "generator", "keywords"};
    static String[] SANDBOX_VALUES = new String[]{"", "allow-forms", "allow-same-origin", "allow-scripts", "allow-top-navigation"};
    static String[] SCOPE_VALUES = new String[]{"", "col", "colgroup", "row", "rowgroup"};
    static String[] AREA_SHAPE_VALUES = new String[]{"", "default", "rect", "circle", "poly"};
    static String[] TYPES = new String[]{"button", "checkbox", "color", "date", "datetime", "email", "file", "hidden", "image", "month", "number", "password", "radio", "range", "reset", "search", "submit", "text", "tel", "time", "url", "week"};
    static String[] OL_TYPES = new String[]{"", "1", "a", "A", "i", "I"};
    static String[] COMMAND_TYPES = new String[]{"", "checkbox", "command", "radio"};
    static String[] STYLE_TYPES = new String[]{"", "text/css"};
    static String[] REL_VALUES = new String[]{"", "alternate", "archives", "author", "bookmark", "external", "first", "help", "icon", "last", "license", "next", "nofollow", "noreferrer", "pingback", "prefetch", "prev", "search", "sidebar", "stylesheet", "tag", "up"};
    static String[] AREA_REL_VALUES = new String[]{"", "alternate", "author", "bookmark", "help", "license", "next", "nofollow", "noreferrer", "prefetch", "prev", "search", "tag"};
    static String[] LINK_MIME_TYPES = new String[]{"", "text/css"};
    static String[] SCRIPT_MIME_TYPES = new String[]{"", "text/javascript", "application/javascript"};
    static String[] MENU_TYPES = new String[]{"", "list", "context", "toolbar"};
    static String[] SOURCE_TYPES = new String[]{"", "audio/ogg", "audio/mpeg", "video/ogg", "video/mp4", "video/webm"};
    static String[] WRAP_VALUES = new String[]{"soft", "hard"};
    static String[] WRAP_DESCRIPTIONS = new String[]{WizardDescriptions.textareaWrapSoft, WizardDescriptions.textareaWrapHard};

    public static IFieldEditor createAltEditor() {
        return JQueryFieldEditorFactory.createAltEditor();
    }

    public static IFieldEditor createAsyncEditor() {
        return SwtFieldEditorFactory.INSTANCE.createCheckboxEditor("async", WizardMessages.asyncLabel, false, WizardDescriptions.scriptAsync);
    }

    public static IFieldEditor createBorderEditor() {
        return SwtFieldEditorFactory.INSTANCE.createComboEditor("border", WizardMessages.borderLabel, HTMLFieldEditorFactory.toList(BORDER_VALUES), (Object)"", true, WizardDescriptions.tableBorder);
    }

    public static IFieldEditor createCiteEditor(String description) {
        return SwtFieldEditorFactory.INSTANCE.createTextEditor("cite", WizardMessages.citeLabel, "", description);
    }

    public static IFieldEditor createChallengeEditor() {
        return SwtFieldEditorFactory.INSTANCE.createCheckboxEditor("challenge", WizardMessages.challengeLabel, false, WizardDescriptions.keygenChallenge);
    }

    public static IFieldEditor createCharsetEditor() {
        return SwtFieldEditorFactory.INSTANCE.createComboEditor("charset", WizardMessages.charsetLabel, HTMLFieldEditorFactory.toList(CHARSET_LIST), (Object)"", true, WizardDescriptions.metaCharset);
    }

    public static IFieldEditor createColsEditor() {
        return SwtFieldEditorFactory.INSTANCE.createTextEditor("cols", WizardMessages.colsLabel, "");
    }

    public static IFieldEditor createColspanEditor() {
        return SwtFieldEditorFactory.INSTANCE.createTextEditor("colspan", WizardMessages.colspanLabel, "", WizardDescriptions.tdColspan);
    }

    public static IFieldEditor createContentEditor() {
        return SwtFieldEditorFactory.INSTANCE.createTextEditor("content", WizardMessages.metaContentLabel, "", WizardDescriptions.metaContent);
    }

    public static IFieldEditor createCoordsEditor() {
        return SwtFieldEditorFactory.INSTANCE.createTextEditor("coords", WizardMessages.coordsLabel, "", WizardDescriptions.areaCoords);
    }

    public static IFieldEditor createCrossoriginEditor() {
        return JQueryFieldEditorFactory.createCrossoriginEditor();
    }

    public static IFieldEditor createDatetimeEditor(String description) {
        return SwtFieldEditorFactory.INSTANCE.createTextEditor("datetime", WizardMessages.datetimeLabel, "", description);
    }

    public static IFieldEditor createDefaultEditor() {
        return SwtFieldEditorFactory.INSTANCE.createCheckboxEditor("default", WizardMessages.defaultLabel, false, WizardDescriptions.trackDefault);
    }

    public static IFieldEditor createDeferEditor() {
        return SwtFieldEditorFactory.INSTANCE.createCheckboxEditor("defer", WizardMessages.deferLabel, false, WizardDescriptions.scriptDefer);
    }

    public static IFieldEditor createDirEditor() {
        return SwtFieldEditorFactory.INSTANCE.createRadioEditor("dir", WizardMessages.dirLabel, HTMLFieldEditorFactory.toList(DIR_LIST), HTMLFieldEditorFactory.toList(DIR_LIST), (Object)"ltr", WizardDescriptions.bdoDir);
    }

    public static IFieldEditor createDownloadEditor() {
        return SwtFieldEditorFactory.INSTANCE.createTextEditor("download", WizardMessages.downloadLabel, "", WizardDescriptions.areaDownload);
    }

    public static IFieldEditor createFormEditor() {
        return JQueryFieldEditorFactory.createFormReferenceEditor();
    }

    public static IFieldEditor createHeadersEditor() {
        return SwtFieldEditorFactory.INSTANCE.createTextEditor("headers", WizardMessages.headersLabel, "", WizardDescriptions.tdHeaders);
    }

    public static IFieldEditor createHeightEditor(String description) {
        return JQueryFieldEditorFactory.createHeightEditor(description);
    }

    public static IFieldEditor createHighEditor() {
        return SwtFieldEditorFactory.INSTANCE.createTextEditor("high", WizardMessages.highLabel, "", WizardDescriptions.meterHigh);
    }

    public static IFieldEditor createHttpEquiveEditor() {
        return SwtFieldEditorFactory.INSTANCE.createComboEditor("http-equiv", WizardMessages.http_equiveLabel, HTMLFieldEditorFactory.toList(HTTP_EQUIV_VALUES), (Object)"", true, WizardDescriptions.metaHttpEquive);
    }

    public static IFieldEditor createIconEditor(IFile context) {
        ButtonFieldEditor.ButtonPressedAction action = JQueryFieldEditorFactory.createSelectWorkspaceImageAction(CommonUIMessages.SWT_FIELD_EDITOR_FACTORY_BROWS, context);
        return HTMLFieldEditorFactory.createBrowseWorkspaceEditor("icon", WizardMessages.iconLabel, WizardDescriptions.commandIcon, action);
    }

    public static IFieldEditor createIDEditor() {
        return SwtFieldEditorFactory.INSTANCE.createTextEditor("id", WizardMessages.idLabel, "", WizardDescriptions.elementId);
    }

    public static IFieldEditor createIsmapEditor() {
        return JQueryFieldEditorFactory.createIsmapEditor();
    }

    public static IFieldEditor createKeytypeEditor() {
        return SwtFieldEditorFactory.INSTANCE.createComboEditor("keytype", WizardMessages.keytypeLabel, HTMLFieldEditorFactory.toList(KEYTYPE_VALUES), (Object)"", false, WizardDescriptions.keygenKeytype);
    }

    public static IFieldEditor createKindEditor() {
        return SwtFieldEditorFactory.INSTANCE.createComboEditor("kind", WizardMessages.kindLabel, HTMLFieldEditorFactory.toList(KIND_VALUES), (Object)"", false, WizardDescriptions.trackKind);
    }

    public static IFieldEditor createLowEditor() {
        return SwtFieldEditorFactory.INSTANCE.createTextEditor("low", WizardMessages.lowLabel, "", WizardDescriptions.meterLow);
    }

    public static IFieldEditor createManifestEditor() {
        return SwtFieldEditorFactory.INSTANCE.createTextEditor("manifest", WizardMessages.manifestLabel, "", WizardDescriptions.htmlManifest);
    }

    public static IFieldEditor createMaxEditor(String description) {
        return SwtFieldEditorFactory.INSTANCE.createTextEditor("max", WizardMessages.maxLabel, "", description);
    }

    public static IFieldEditor createMinEditor(String description) {
        return SwtFieldEditorFactory.INSTANCE.createTextEditor("min", WizardMessages.minLabel, "", description);
    }

    public static IFieldEditor createMultipleEditor() {
        return SwtFieldEditorFactory.INSTANCE.createCheckboxEditor("multiple", WizardMessages.multipleLabel, false, WizardDescriptions.inputMultiple);
    }

    public static IFieldEditor createMetaNameEditor() {
        return SwtFieldEditorFactory.INSTANCE.createComboEditor("name", WizardMessages.nameLabel, HTMLFieldEditorFactory.toList(META_NAME_VALUES), (Object)"", true, WizardDescriptions.metaName);
    }

    public static IFieldEditor createNovalidateEditor() {
        return SwtFieldEditorFactory.INSTANCE.createCheckboxEditor("novalidate", WizardMessages.novalidateLabel, false, WizardDescriptions.formValidate);
    }

    public static IFieldEditor createOpenEditor(String description) {
        return SwtFieldEditorFactory.INSTANCE.createCheckboxEditor("open", WizardMessages.openLabel, false, description);
    }

    public static IFieldEditor createOptimumEditor() {
        return SwtFieldEditorFactory.INSTANCE.createTextEditor("optimum", WizardMessages.optimumLabel, "", WizardDescriptions.meterOptimum);
    }

    public static IFieldEditor createRadiogroupEditor() {
        return SwtFieldEditorFactory.INSTANCE.createTextEditor("radiogroup", WizardMessages.radiogroupLabel, "", WizardDescriptions.commandRadiogroup);
    }

    public static IFieldEditor createReversedEditor() {
        return SwtFieldEditorFactory.INSTANCE.createCheckboxEditor("reversed", WizardMessages.reversedLabel, false, WizardDescriptions.olReversed);
    }

    public static IFieldEditor createRowsEditor() {
        return SwtFieldEditorFactory.INSTANCE.createTextEditor("rows", "Rows:", "");
    }

    public static IFieldEditor createRowspanEditor() {
        return SwtFieldEditorFactory.INSTANCE.createTextEditor("rowspan", WizardMessages.rowspanLabel, "", WizardDescriptions.tdRowspan);
    }

    public static IFieldEditor createSandboxEditor() {
        return SwtFieldEditorFactory.INSTANCE.createComboEditor("sandbox", WizardMessages.sandboxLabel, HTMLFieldEditorFactory.toList(SANDBOX_VALUES), (Object)"", true, WizardDescriptions.iframeSandbox);
    }

    public static IFieldEditor createScopeEditor() {
        return SwtFieldEditorFactory.INSTANCE.createComboEditor("scope", WizardMessages.scopeLabel, HTMLFieldEditorFactory.toList(SCOPE_VALUES), (Object)"", true, WizardDescriptions.thScope);
    }

    public static IFieldEditor createScopedEditor() {
        return SwtFieldEditorFactory.INSTANCE.createCheckboxEditor("scoped", WizardMessages.scopedLabel, false, WizardDescriptions.styleScoped);
    }

    public static IFieldEditor createSeamlessEditor() {
        return SwtFieldEditorFactory.INSTANCE.createCheckboxEditor("seamless", WizardMessages.seamlessLabel, false, WizardDescriptions.iframeSeamless);
    }

    public static IFieldEditor createShapeEditor() {
        return SwtFieldEditorFactory.INSTANCE.createComboEditor("shape", WizardMessages.shapeLabel, HTMLFieldEditorFactory.toList(AREA_SHAPE_VALUES), (Object)"", false, WizardDescriptions.areaShape);
    }

    public static IFieldEditor createSizeEditor() {
        return SwtFieldEditorFactory.INSTANCE.createTextEditor("size", WizardMessages.sizeLabel, "", WizardDescriptions.selectSize);
    }

    public static IFieldEditor createSrcEditor(IFile context) {
        ButtonFieldEditor.ButtonPressedAction action = JQueryFieldEditorFactory.createSelectWorkspaceImageAction(CommonUIMessages.SWT_FIELD_EDITOR_FACTORY_BROWS, context);
        return HTMLFieldEditorFactory.createBrowseWorkspaceEditor("src", WizardMessages.srcLabel, WizardDescriptions.imageSrc, action);
    }

    private static IFieldEditor createBrowseWorkspaceEditor(String name, String label, String description, ButtonFieldEditor.ButtonPressedAction action) {
        CompositeEditor editor = new CompositeEditor(name, label, (Object)"");
        editor.addFieldEditors(new IFieldEditor[]{new LabelFieldEditor(name, label, description), new TextFieldEditor(name, label, ""), new ButtonFieldEditor(name, action, (Object)"")});
        action.setFieldEditor((IFieldEditor)editor);
        return editor;
    }

    public static IFieldEditor createAudioSrcEditor(IFile context) {
        ButtonFieldEditor.ButtonPressedAction action = JQueryFieldEditorFactory.createSelectWorkspaceAudioAction(CommonUIMessages.SWT_FIELD_EDITOR_FACTORY_BROWS, context);
        return HTMLFieldEditorFactory.createBrowseWorkspaceEditor("src", WizardMessages.srcLabel, WizardDescriptions.audioSrc, action);
    }

    public static IFieldEditor createSourceSrcEditor(IFile context, String description) {
        ButtonFieldEditor.ButtonPressedAction action = JQueryFieldEditorFactory.createSelectWorkspaceSourceAction(CommonUIMessages.SWT_FIELD_EDITOR_FACTORY_BROWS, context);
        return HTMLFieldEditorFactory.createBrowseWorkspaceEditor("src", WizardMessages.srcLabel, description, action);
    }

    public static IFieldEditor createStartEditor() {
        return SwtFieldEditorFactory.INSTANCE.createTextEditor("start", WizardMessages.startLabel, "", WizardDescriptions.olStart);
    }

    public static IFieldEditor createTextSrcEditor(String description) {
        return SwtFieldEditorFactory.INSTANCE.createTextEditor("src", WizardMessages.srcLabel, "", description);
    }

    public static IFieldEditor createTextTypeEditor(String description) {
        return SwtFieldEditorFactory.INSTANCE.createTextEditor("type", WizardMessages.typeLabel, "", description);
    }

    public static IFieldEditor createInputTypeEditor() {
        return SwtFieldEditorFactory.INSTANCE.createComboEditor("type", WizardMessages.textTypeLabel, HTMLFieldEditorFactory.toList(TYPES), (Object)"", false, WizardDescriptions.textInputType);
    }

    public static IFieldEditor createOlTypeEditor() {
        return SwtFieldEditorFactory.INSTANCE.createComboEditor("type", WizardMessages.textTypeLabel, HTMLFieldEditorFactory.toList(OL_TYPES), (Object)"", false, WizardDescriptions.olType);
    }

    public static IFieldEditor createCommandTypeEditor() {
        return SwtFieldEditorFactory.INSTANCE.createComboEditor("type", WizardMessages.textTypeLabel, HTMLFieldEditorFactory.toList(COMMAND_TYPES), (Object)"", false, WizardDescriptions.commandType);
    }

    public static IFieldEditor createStyleTypeEditor() {
        return SwtFieldEditorFactory.INSTANCE.createComboEditor("type", WizardMessages.textTypeLabel, HTMLFieldEditorFactory.toList(STYLE_TYPES), (Object)"", true, WizardDescriptions.styleType);
    }

    public static IFieldEditor createLinkRelEditor() {
        return SwtFieldEditorFactory.INSTANCE.createComboEditor("rel", WizardMessages.relLabel, HTMLFieldEditorFactory.toList(REL_VALUES), (Object)"", false, WizardDescriptions.linkRel);
    }

    public static IFieldEditor createAreaRelEditor() {
        return SwtFieldEditorFactory.INSTANCE.createComboEditor("rel", WizardMessages.relLabel, HTMLFieldEditorFactory.toList(AREA_REL_VALUES), (Object)"", false, WizardDescriptions.linkRel);
    }

    public static IFieldEditor createLinkTypeEditor() {
        return SwtFieldEditorFactory.INSTANCE.createComboEditor("type", WizardMessages.mimeType, HTMLFieldEditorFactory.toList(LINK_MIME_TYPES), (Object)"", true, WizardDescriptions.linkType);
    }

    public static IFieldEditor createScriptTypeEditor() {
        return SwtFieldEditorFactory.INSTANCE.createComboEditor("type", WizardMessages.mimeType, HTMLFieldEditorFactory.toList(SCRIPT_MIME_TYPES), (Object)"", true, WizardDescriptions.scriptType);
    }

    public static IFieldEditor createMenuTypeEditor() {
        return SwtFieldEditorFactory.INSTANCE.createComboEditor("type", WizardMessages.typeLabel, HTMLFieldEditorFactory.toList(MENU_TYPES), (Object)"", true, WizardDescriptions.menuType);
    }

    public static IFieldEditor createSourceTypeEditor() {
        return SwtFieldEditorFactory.INSTANCE.createComboEditor("type", WizardMessages.typeLabel, HTMLFieldEditorFactory.toList(SOURCE_TYPES), (Object)"", true, WizardDescriptions.audioType);
    }

    public static IFieldEditor createURLEditor() {
        return JQueryFieldEditorFactory.createURLEditor("href");
    }

    public static IFieldEditor createUsemapEditor() {
        return JQueryFieldEditorFactory.createUsemapEditor();
    }

    public static IFieldEditor createWidthEditor(String description) {
        return JQueryFieldEditorFactory.createWidthEditor(description);
    }

    public static IFieldEditor createWrapEditor() {
        return SwtFieldEditorFactory.INSTANCE.createRadioEditor("wrap", WizardMessages.wrapLabel, HTMLFieldEditorFactory.toList(WRAP_VALUES), HTMLFieldEditorFactory.toList(WRAP_VALUES), (Object)"soft", WizardDescriptions.textareaWrap, HTMLFieldEditorFactory.toList(WRAP_DESCRIPTIONS));
    }

    static List<String> toList(String[] values) {
        ArrayList<String> list = new ArrayList<String>();
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            list.add(s);
            ++n2;
        }
        return list;
    }
}

