/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.text.ext.hyperlink;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.jst.web.ui.internal.text.ext.hyperlink.OpenWithEditorExtension;
import org.jboss.tools.jst.web.ui.internal.text.ext.hyperlink.OpenWithEditorExtensionManager;
import org.jboss.tools.jst.web.ui.internal.text.ext.hyperlink.OpenWithEditorHyperlink;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class JQueryMobileHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        ArrayList<OpenWithEditorHyperlink> links = new ArrayList<OpenWithEditorHyperlink>();
        IFile file = this.getFile();
        if (file == null) {
            return null;
        }
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(textViewer.getDocument());
        try {
            IStructuredDocumentRegion textRegion;
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = JQueryMobileHyperlinkDetector.findNodeForOffset(xmlDocument, region.getOffset());
            if (n != null && n.getNodeType() == 1 && n instanceof ElementImpl && (textRegion = ((ElementImpl)n).getStartStructuredDocumentRegion()) != null) {
                Region nodeRegion = new Region(textRegion.getStart(), textRegion.getLength());
                String id = this.findID(n);
                if (id != null) {
                    OpenWithEditorExtension[] extensions;
                    String url = file.getLocation().toFile().toURI() + "#" + id;
                    String shortName = String.valueOf(file.getName()) + "#" + id;
                    OpenWithEditorExtension[] openWithEditorExtensionArray = extensions = OpenWithEditorExtensionManager.INSTANCES;
                    int n2 = extensions.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        OpenWithEditorExtension extension = openWithEditorExtensionArray[n3];
                        links.add(new OpenWithEditorHyperlink(textViewer.getDocument(), (IRegion)nodeRegion, shortName, url, extension));
                        ++n3;
                    }
                }
            }
            if (links.size() == 0) {
                return null;
            }
            IHyperlink[] iHyperlinkArray = links.toArray(new IHyperlink[links.size()]);
            return iHyperlinkArray;
        }
        finally {
            smw.dispose();
        }
    }

    public static Node findNodeForOffset(Node node, int offset) {
        return node instanceof IDOMNode ? JQueryMobileHyperlinkDetector.findNodeForOffset((IDOMNode)node, offset) : null;
    }

    public static Node findNodeForOffset(IDOMNode node, int offset) {
        IndexedRegion region = node.getModel().getIndexedRegion(offset);
        if (region instanceof Node) {
            return (Node)region;
        }
        return null;
    }

    private String findID(Node node) {
        if (this.checkAttribute(node, "data-role", "page")) {
            return this.getAttributeValue(node, "id");
        }
        return null;
    }

    private String getAttributeValue(Node node, String attributeName) {
        Node attribute;
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null && (attribute = attributes.getNamedItem(attributeName)) != null) {
            return attribute.getNodeValue();
        }
        return null;
    }

    private boolean checkAttribute(Node node, String attributeName, String attributeValue) {
        Node attribute;
        NamedNodeMap attributes = node.getAttributes();
        return attributes != null && (attribute = attributes.getNamedItem(attributeName)) != null && attribute.getNodeValue().equalsIgnoreCase(attributeValue);
    }

    private IFile getFile() {
        IEditorInput input;
        IEditorPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (part != null && (input = part.getEditorInput()) instanceof FileEditorInput) {
            return ((FileEditorInput)input).getFile();
        }
        return null;
    }
}

