/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.text.ext.hyperlink;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.common.el.core.resolver.ELSegmentImpl;
import org.jboss.tools.common.el.core.resolver.Var;
import org.jboss.tools.common.text.ext.hyperlink.xpl.HierarchyInformationControl;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.internal.text.ext.hyperlink.ELHyperlink;

class VarHierarchyInformationControl
extends HierarchyInformationControl {
    public VarHierarchyInformationControl(Shell parent, String title, int shellStyle, int tableStyle, IHyperlink[] hyperlinks) {
        super(parent, title, shellStyle, tableStyle, hyperlinks);
    }

    protected HierarchyInformationControl.BeanTableLabelProvider createTableLableProvider() {
        return new VarTableLabelProvider();
    }

    class VarTableLabelProvider
    extends HierarchyInformationControl.BeanTableLabelProvider {
        VarTableLabelProvider() {
            super((HierarchyInformationControl)VarHierarchyInformationControl.this);
        }

        public StyledString getStyledText(Object element) {
            StyledString sb = new StyledString();
            if (element instanceof ELHyperlink) {
                ELHyperlink el = (ELHyperlink)((Object)element);
                ELSegmentImpl.VarOpenable v = (ELSegmentImpl.VarOpenable)el.openable;
                Var var = v.getVar();
                Document doc = new Document(FileUtil.getContentFromEditorOrFile((IFile)var.getFile()));
                int line = -1;
                try {
                    if (var.getDeclarationOffset() < doc.getLength()) {
                        line = doc.getLineOfOffset(var.getDeclarationOffset()) + 1;
                    }
                }
                catch (BadLocationException e) {
                    WebUiPlugin.getDefault().logError(e);
                }
                sb.append(var.getFile().getName(), NAME_STYLE);
                if (line > 0) {
                    sb.append(", line " + line, NAME_STYLE);
                }
                sb.append(" - " + var.getFile().getParent().getFullPath().toString(), PACKAGE_STYLE);
            } else if (element instanceof IHyperlink) {
                sb.append(((IHyperlink)element).getHyperlinkText(), NAME_STYLE);
            }
            return sb;
        }
    }
}

