/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.text.ext.hyperlink.jsp;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsp.core.internal.contentmodel.TaglibController;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TLDCMDocumentManager;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TaglibTracker;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlinkPartitioner;
import org.jboss.tools.common.text.ext.hyperlink.HyperlinkRegion;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkPartitionRecognizer;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkRegion;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.jst.web.tld.ITaglibMapping;
import org.jboss.tools.jst.web.tld.WebProjectFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class JSPRootHyperlinkPartitioner
extends AbstractHyperlinkPartitioner
implements IHyperlinkPartitionRecognizer {
    public static final String JSP_ROOT_PARTITION = "org.jboss.tools.common.text.ext.jsp.JSP_ROOT";

    protected IHyperlinkRegion parse(IDocument document, int offset, IHyperlinkRegion superRegion) {
        if (!this.recognize(document, offset, superRegion)) {
            return null;
        }
        String axis = String.valueOf(JSPRootHyperlinkPartitioner.computeAxis(document, superRegion.getOffset())) + "/";
        String contentType = superRegion.getContentType();
        String type = JSP_ROOT_PARTITION;
        int superLength = superRegion.getLength();
        int superOffset = superRegion.getOffset();
        return new HyperlinkRegion(superOffset, superLength, axis, contentType, type);
    }

    public static String computeAxis(IDocument document, int offset) {
        String axis = "";
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(document);
        try {
            ITaglibMapping tm;
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)offset);
            Map trackersMap = JSPRootHyperlinkPartitioner.getTrackersMap(document, offset);
            IFile file = smw.getFile();
            XModel xModel = AbstractHyperlink.getXModel((IFile)file);
            ITaglibMapping iTaglibMapping = tm = xModel == null ? null : WebProjectFactory.instance.getWebProject(xModel).getTaglibMapping();
            if (n != null) {
                if ((n instanceof Element || n instanceof Attr) && n.getNodeName() != null && n.getNodeName().length() > 0) {
                    Element e;
                    String jsfcAttrValue;
                    String name = n.getNodeName();
                    if (n instanceof Element && (jsfcAttrValue = (e = (Element)n).getAttribute("jsfc")) != null && jsfcAttrValue.trim().length() > 0) {
                        name = jsfcAttrValue;
                    }
                    String nodeName = JSPRootHyperlinkPartitioner.extractName(name, trackersMap, tm);
                    axis = "/" + nodeName;
                }
                Node parent = n instanceof Attr ? ((Attr)n).getOwnerElement() : n.getParentNode();
                while (parent instanceof Element) {
                    String nodeName;
                    Element e;
                    String jsfcAttrValue;
                    String name = parent.getNodeName();
                    if (parent instanceof Element && (jsfcAttrValue = (e = (Element)parent).getAttribute("jsfc")) != null && jsfcAttrValue.trim().length() > 0) {
                        name = jsfcAttrValue;
                    }
                    if ((nodeName = JSPRootHyperlinkPartitioner.extractName(name, trackersMap, tm)) != null && nodeName.length() > 0) {
                        axis = "/" + nodeName + axis;
                    }
                    parent = parent.getParentNode();
                }
            }
        }
        finally {
            smw.dispose();
        }
        if (axis == null || axis.length() == 0) {
            axis = "";
        }
        return axis;
    }

    public static String extractName(String name, Map trackersMap, ITaglibMapping tm) {
        if (trackersMap == null || trackersMap.size() == 0) {
            return name;
        }
        if (name == null) {
            return null;
        }
        int column = name.indexOf(":");
        if (column == -1) {
            return name;
        }
        String prefix = name.substring(0, column);
        if (prefix == null || prefix.trim().length() == 0) {
            return name;
        }
        String uri = (String)trackersMap.get(prefix);
        if (uri == null || uri.length() == 0) {
            return name;
        }
        String resolvedUri = tm == null ? uri : tm.resolveURI(uri);
        return "[" + resolvedUri + "]" + name.substring(column);
    }

    public static Map getTrackersMap(IDocument document, int offset) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(document);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            TLDCMDocumentManager manager = TaglibController.getTLDCMDocumentManager((IDocument)document);
            List trackers = manager == null ? null : manager.getCMDocumentTrackers(offset);
            Map<String, String> map = new HashMap<String, String>();
            int i = 0;
            while (trackers != null && i < trackers.size()) {
                TaglibTracker tt = (TaglibTracker)trackers.get(i);
                String prefix = tt.getPrefix();
                String uri = tt.getURI();
                if (prefix != null && prefix.trim().length() > 0 && uri != null && uri.trim().length() > 0) {
                    map.put(prefix.trim(), uri.trim());
                }
                ++i;
            }
            Map<String, String> map2 = map = JSPRootHyperlinkPartitioner.addAlternativeTrackersMap(map, document, offset);
            return map2;
        }
        finally {
            smw.dispose();
        }
    }

    public static Map<String, String> addAlternativeTrackersMap(Map<String, String> map, IDocument document, int offset) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(document);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            if (map == null) {
                map = new HashMap<String, String>();
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)offset);
            while (n != null) {
                if (!(n instanceof Element)) {
                    if (n instanceof Attr) {
                        n = ((Attr)n).getOwnerElement();
                        continue;
                    }
                    n = n.getParentNode();
                    continue;
                }
                NamedNodeMap attrs = n.getAttributes();
                int j = 0;
                while (attrs != null && j < attrs.getLength()) {
                    Attr a = (Attr)attrs.item(j);
                    String name = a.getName();
                    if (name.startsWith("xmlns:")) {
                        String uri = a.getValue();
                        String prefix = name.substring("xmlns:".length());
                        map.put(prefix.trim(), uri.trim());
                    }
                    ++j;
                }
                n = n.getParentNode();
            }
            Map<String, String> map2 = map;
            return map2;
        }
        finally {
            smw.dispose();
        }
    }

    public boolean recognize(IDocument document, int offset, IHyperlinkRegion region) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(document);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return false;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)offset);
            return n != null;
            {
            }
        }
        finally {
            smw.dispose();
        }
    }
}

