/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.wizards.project;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.jboss.tools.common.meta.key.WizardKeys;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.jst.web.project.helpers.NewWebProjectContext;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.operation.WebNatureOperation;

public abstract class NewWebProjectWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private static final String CANNOT_CREATE_LOCATION = "NewStrutsProjectWizard.CannotCreateLocation";
    protected IWorkbench workbench;
    protected IStructuredSelection selection;
    protected IConfigurationElement fConfigElement;
    protected NewWebProjectContext context;

    public NewWebProjectWizard() {
        this.setNeedsProgressMonitor(true);
        this.setHelpAvailable(false);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
    }

    public boolean canFinish() {
        return super.canFinish() && this.context.getRegisterServerContext().getErrorMessage() == null;
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.fConfigElement = cfig;
    }

    protected abstract IRunnableWithProgress createOperation();

    public boolean performFinish() {
        boolean result = true;
        final WebNatureOperation runnable = (WebNatureOperation)this.createOperation();
        WorkspaceModifyDelegatingOperation op1 = new WorkspaceModifyDelegatingOperation(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                runnable.clearProjectRoot();
            }
        });
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)runnable);
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)op1);
            if (!runnable.isCancelled()) {
                this.getContainer().run(true, false, (IRunnableWithProgress)op);
                BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
                BasicNewResourceWizard.selectAndReveal((IResource)this.context.getProject(), (IWorkbenchWindow)ModelUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow());
            }
            if (runnable.isCancelled()) {
                result = false;
            }
        }
        catch (InvocationTargetException e) {
            WebUiPlugin.getPluginLog().logError((Throwable)e);
            String message = String.valueOf(WizardKeys.getString((String)"NewStrutsProjectWizard.CannotCreateLocation.ErrorMessage")) + ": " + this.context.getLocationPath();
            Status status = new Status(4, "org.jboss.tools.jst.web.ui", 0, message, (Throwable)e);
            result = false;
        }
        catch (InterruptedException e) {
            WebUiPlugin.getPluginLog().logError((Throwable)e);
            String message = String.valueOf(WizardKeys.getString((String)"NewStrutsProjectWizard.CannotCreateLocation.ErrorMessage")) + ": " + this.context.getLocationPath();
            Status status = new Status(4, "org.jboss.tools.jst.web.ui", 0, message, (Throwable)e);
            result = false;
        }
        return result;
    }
}

