/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.model.handlers;

import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.jboss.tools.common.meta.action.XAction;
import org.jboss.tools.common.meta.action.impl.XActionImpl;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultRedirectHandler;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.jst.web.model.ReferenceObject;

public class WebRedirectHandler
extends DefaultRedirectHandler {
    protected Set<String> entities;
    private boolean hidden = false;

    protected XModelObject getTargetObject(XModelObject object) {
        XModelObject target = null;
        if (object instanceof ReferenceObject) {
            ReferenceObject refObject = (ReferenceObject)object;
            target = refObject.getReference();
        }
        return target;
    }

    protected XModelObject checkEntity(XModelObject object) {
        if (this.entities == null) {
            this.entities = new HashSet<String>();
            String en = this.action.getProperty("entity");
            if (en != null) {
                StringTokenizer tokenizer = new StringTokenizer(en, ":");
                while (tokenizer.hasMoreTokens()) {
                    this.entities.add(tokenizer.nextToken());
                }
            }
        }
        if (object != null && this.entities.size() > 0 && !this.entities.contains(object.getModelEntity().getName())) {
            return null;
        }
        return object;
    }

    protected XModelObject getTrueSource(XModelObject object) {
        return this.checkEntity(this.getTargetObject(object));
    }

    public boolean isEnabled(XModelObject object) {
        if (!this.checkConfigVersion(object)) {
            return false;
        }
        XAction a = this.getTrueAction(object);
        if (a != null) {
            boolean enabled = a.isEnabled(this.getTrueSource(object));
            this.hidden = false;
            ((XActionImpl)this.action).setDisplayName(a.getDisplayName());
            return enabled;
        }
        this.hidden = true;
        return false;
    }

    public boolean hide(boolean enabled) {
        return this.hidden || super.hide(enabled);
    }

    private boolean checkConfigVersion(XModelObject object) {
        String entity = this.action.getProperty("configEntity");
        if (entity == null) {
            return true;
        }
        XModelObject f = FileSystemsHelper.getFile((XModelObject)object);
        if (f == null) {
            return true;
        }
        boolean b = f.getModelEntity().getName().equals(entity);
        if (b) {
            return true;
        }
        this.hidden = true;
        return b;
    }
}

