/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.model.helpers.autolayout;

import java.util.HashMap;
import java.util.Map;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.jst.web.model.helpers.WebProcessStructureHelper;
import org.jboss.tools.jst.web.model.helpers.autolayout.Groups;
import org.jboss.tools.jst.web.model.helpers.autolayout.Item;
import org.jboss.tools.jst.web.model.helpers.autolayout.LayuotConstants;
import org.jboss.tools.jst.web.model.helpers.autolayout.TransitionArranger;
import org.jboss.tools.jst.web.model.process.WebProcessConstants;

public class Items
implements WebProcessConstants {
    protected LayuotConstants constants = this.createConstants();
    protected WebProcessStructureHelper h = new WebProcessStructureHelper();
    protected XModelObject process;
    protected Item[] items;
    protected Map<String, Item> paths = new HashMap<String, Item>();
    protected Groups groups = new Groups();
    protected boolean override = false;

    protected LayuotConstants createConstants() {
        return new LayuotConstants();
    }

    public boolean isZigzagging() {
        return true;
    }

    public void setOverride(boolean b) {
        this.override = b;
    }

    public void setProcess(XModelObject process) {
        this.process = process;
        this.load();
    }

    private void load() {
        this.initItems();
        if (this.isAllSet()) {
            return;
        }
        this.buildBinds();
        this.groups.load(this.items);
        this.print();
    }

    private void initItems() {
        XModelObject[] is = this.process.getChildren();
        this.items = new Item[is.length];
        int i = 0;
        while (i < is.length) {
            Item item;
            this.items[i] = item = new Item();
            this.paths.put(is[i].getPathPart(), item);
            item.n = i;
            item.object = is[i];
            int[] shape = this.h.asIntArray(is[i], "shape");
            if (!this.override && shape != null && shape.length > 1) {
                item.x = shape[0];
                item.y = shape[1];
                if (item.x != 0 && item.y != 0) {
                    item.isSet = true;
                }
                item.ix = item.x / this.constants.deltaX;
                item.iy = item.y / this.constants.deltaY;
                if (item.ix < 0) {
                    item.ix = 0;
                }
                if (item.iy < 0) {
                    item.iy = 0;
                }
                if (item.ix >= Groups.FX) {
                    item.ix = Groups.FX - 1;
                }
                if (item.iy >= Groups.FY) {
                    item.iy = Groups.FY - 1;
                }
            }
            this.initItem(item);
            ++i;
        }
    }

    protected void initItem(Item item) {
    }

    public XModelObject[] getOutput(XModelObject itemObject) {
        return itemObject.getChildren();
    }

    private boolean isAllSet() {
        int i = 0;
        while (i < this.items.length) {
            if (!this.items[i].isSet()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void buildBinds() {
        int i = 0;
        while (i < this.items.length) {
            XModelObject[] xModelObjectArray;
            if (this.items[i].weight < 0 || this.items[i].isComment()) {
                XModelObject[] xModelObjectArray2 = new XModelObject[1];
                xModelObjectArray = xModelObjectArray2;
                xModelObjectArray2[0] = this.items[i].object;
            } else {
                xModelObjectArray = this.getOutput(this.items[i].object);
            }
            XModelObject[] ts = xModelObjectArray;
            int j = 0;
            while (j < ts.length) {
                Item item2;
                String target = ts[j].getAttributeValue("target");
                if (target != null && target.length() != 0 && (item2 = this.paths.get(target)) != null) {
                    if (this.items[i].isComment()) {
                        item2.addComment(this.items[i].n);
                        this.items[i].isOwned = true;
                    } else if (item2.weight >= 0) {
                        item2.addInput(this.items[i].n, ts[j]);
                        this.items[i].addOutput(item2.n);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    protected TransitionArranger createTransitionArranger() {
        return new TransitionArranger();
    }

    private void print() {
        int i = 0;
        while (i < this.items.length) {
            this.items[i].print();
            ++i;
        }
    }
}

