/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.validation;

import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.validation.ValidationErrorManager;
import org.jboss.tools.jst.web.model.helpers.WebAppHelper;
import org.jboss.tools.jst.web.validation.Check;
import org.jboss.tools.jst.web.validation.WebXMLValidatorMessages;

public class CheckRoleReferenceName
extends Check {
    static String ATTR = "role-name";

    public CheckRoleReferenceName(ValidationErrorManager manager, String preference, String attr) {
        super(manager, preference, attr);
    }

    @Override
    public void check(XModelObject object) {
        String roleName = object.getAttributeValue(this.attr);
        if (roleName == null) {
            return;
        }
        if (roleName.length() == 0) {
            this.fireMessage(object, WebXMLValidatorMessages.EMPTY, this.attr);
        } else if (!this.isRoleNameOk(object, roleName)) {
            this.fireMessage(object, WebXMLValidatorMessages.ROLE_NOT_EXISTS, this.attr, roleName);
        }
    }

    boolean isRoleNameOk(XModelObject mapping, String roleName) {
        if (roleName.equalsIgnoreCase("NONE")) {
            return true;
        }
        if ("*".equals(roleName)) {
            return true;
        }
        return this.findRole(mapping, roleName) != null;
    }

    XModelObject findRole(XModelObject mapping, String name) {
        XModelObject webxml = WebAppHelper.getParentFile(mapping);
        return webxml == null ? null : WebAppHelper.findRole(webxml, name);
    }
}

