/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.validation;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.validation.ContextValidationHelper;
import org.jboss.tools.common.validation.IPreferenceInfo;
import org.jboss.tools.common.validation.IProjectValidationContext;
import org.jboss.tools.common.validation.IValidatingProjectSet;
import org.jboss.tools.common.validation.IValidatingProjectTree;
import org.jboss.tools.common.validation.PreferenceInfoManager;
import org.jboss.tools.common.validation.ValidationErrorManager;
import org.jboss.tools.common.validation.ValidatorManager;
import org.jboss.tools.common.validation.internal.ProjectValidationContext;
import org.jboss.tools.common.validation.internal.SimpleValidatingProjectTree;
import org.jboss.tools.common.validation.internal.ValidatingProjectSet;
import org.jboss.tools.common.web.WebUtils;
import org.jboss.tools.jst.web.WebModelPlugin;
import org.jboss.tools.jst.web.model.helpers.WebAppHelper;
import org.jboss.tools.jst.web.validation.Check;
import org.jboss.tools.jst.web.validation.CheckClass;
import org.jboss.tools.jst.web.validation.CheckFilterMappingName;
import org.jboss.tools.jst.web.validation.CheckResource;
import org.jboss.tools.jst.web.validation.CheckRoleReferenceName;
import org.jboss.tools.jst.web.validation.CheckServletMappingName;
import org.jboss.tools.jst.web.validation.WebXMLPreferences;
import org.jboss.tools.jst.web.validation.WebXMLValidatorMessages;

public class WebXMLCoreValidator
extends ValidationErrorManager
implements org.jboss.tools.common.validation.IValidator {
    public static final String ID = "org.jboss.tools.esb.validator.ESBCoreValidator";
    public static final String PREFERENCE_PAGE_ID = "org.jboss.tools.jst.web.ui.WebXMLValidatorPreferencePage";
    public static final String PROPERTY_PAGE_ID = "org.jboss.tools.jst.web.ui.propertyPages.WebXMLValidatorPreferencePage";
    public static String SHORT_ID = "verification";
    static String XML_EXT = ".xml";
    String projectName;
    Map<IProject, IProjectValidationContext> contexts = new HashMap<IProject, IProjectValidationContext>();
    Map<String, Set<Check>> checks = new HashMap<String, Set<Check>>();

    public WebXMLCoreValidator() {
        this.createChecks();
    }

    protected String getPreference(IProject project, String preferenceKey) {
        return WebXMLPreferences.getInstance().getProjectPreference(project, preferenceKey);
    }

    public int getMaxNumberOfMarkersPerFile(IProject project) {
        return WebXMLPreferences.getMaxNumberOfProblemMarkersPerFile(project);
    }

    private void addCheck(Check check, String ... entities) {
        String[] stringArray = entities;
        int n = entities.length;
        int n2 = 0;
        while (n2 < n) {
            String entity = stringArray[n2];
            Set<Check> cs = this.checks.get(entity);
            if (cs == null) {
                cs = new HashSet<Check>();
                this.checks.put(entity, cs);
            }
            cs.add(check);
            ++n2;
        }
    }

    void createChecks() {
        this.addCheck(new CheckClass(this, WebXMLPreferences.INVALID_EXCEPTION_TYPE, "exception-type", false, null, "java.lang.Exception"), "WebAppErrorPage");
        this.addCheck(new CheckClass(this, WebXMLPreferences.INVALID_FILTER_CLASS, "filter-class"), WebAppHelper.FILTER_ENTITY, WebAppHelper.FILTER_30_ENTITY);
        this.addCheck(new CheckClass(this, WebXMLPreferences.INVALID_SERVLET_CLASS, "servlet-class", false, "javax.servlet.Servlet", null), WebAppHelper.SERVLET_ENTITY, WebAppHelper.SERVLET_30_ENTITY);
        this.addCheck(new CheckClass(this, WebXMLPreferences.INVALID_LISTENER_CLASS, "listener-class"), WebAppHelper.LISTENER_ENTITY, WebAppHelper.LISTENER_24_ENTITY);
        this.addCheck(new CheckClass(this, WebXMLPreferences.INVALID_EXCEPTION_TYPE, "res-type"), "WebAppResourceRef");
        this.addCheck(new CheckClass(this, WebXMLPreferences.INVALID_MESSAGE_DESTINATION_TYPE, "message-destination-type"), "WebAppMessageDestinationRef");
        this.addCheck(new CheckResource(this, WebXMLPreferences.INVALID_TAGLIB_REF, "taglib-location", false, ".tld", WebXMLValidatorMessages.PATH_NOT_TAGLIB), WebAppHelper.TAGLIB_ENTITY);
        this.addCheck(new CheckResource(this, WebXMLPreferences.INVALID_WELCOME_FILE_REF, "file name", false, ".jsp .html .htm .jspx .xhtml", WebXMLValidatorMessages.PATH_NOT_PAGE), "WebAppWelcomFile");
        this.addCheck(new CheckResource(this, WebXMLPreferences.INVALID_ERROR_PAGE_REF, "location", false, null, null).acceptServlet(), "WebAppErrorPage");
        this.addCheck(new CheckResource(this, WebXMLPreferences.INVALID_FORM_ERROR_PAGE_REF, "form-error-page").acceptServlet(), "WebAppLoginConfig");
        this.addCheck(new CheckResource(this, WebXMLPreferences.INVALID_FORM_LOGIN_PAGE_REF, "form-login-page").acceptServlet(), "WebAppLoginConfig");
        this.addCheck(new CheckResource(this, WebXMLPreferences.INVALID_JSP_FILE_REF, "jsp-file"), WebAppHelper.SERVLET_ENTITY, WebAppHelper.SERVLET_30_ENTITY);
        this.addCheck(new CheckResource(this, WebXMLPreferences.INVALID_ICON_REF, "small-icon", true, ".jpg .gif .png", WebXMLValidatorMessages.PATH_NOT_ICON), WebAppHelper.SERVLET_ENTITY, WebAppHelper.SERVLET_30_ENTITY, WebAppHelper.FILTER_ENTITY, WebAppHelper.FILTER_30_ENTITY, "FileWebApp", "FileWebApp24", "FileWebApp25", "FileWebApp30");
        this.addCheck(new CheckResource(this, WebXMLPreferences.INVALID_ICON_REF, "large-icon", true, ".jpg .gif .png", WebXMLValidatorMessages.PATH_NOT_ICON), WebAppHelper.SERVLET_ENTITY, WebAppHelper.SERVLET_30_ENTITY, WebAppHelper.FILTER_ENTITY, WebAppHelper.FILTER_30_ENTITY, "FileWebApp", "FileWebApp24", "FileWebApp25", "FileWebApp30");
        this.addCheck(new CheckServletMappingName((ValidationErrorManager)this, WebXMLPreferences.INVALID_SERVLET_REF, false), WebAppHelper.SERVLET_MAPPING_ENTITY);
        this.addCheck(new CheckServletMappingName((ValidationErrorManager)this, WebXMLPreferences.INVALID_SERVLET_REF, true), WebAppHelper.FILTER_MAPPING_ENTITY, WebAppHelper.FILTER_MAPPING_24_ENTITY);
        this.addCheck(new CheckFilterMappingName(this, WebXMLPreferences.INVALID_FILTER_REF), WebAppHelper.FILTER_MAPPING_ENTITY, WebAppHelper.FILTER_MAPPING_24_ENTITY);
        this.addCheck(new CheckRoleReferenceName(this, WebXMLPreferences.INVALID_ROLE_REF, "role-link"), "WebAppSecurityRoleRef");
        this.addCheck(new CheckRoleReferenceName(this, WebXMLPreferences.INVALID_ROLE_REF, "role-name"), "WebAppRunAs", "WebAppRoleName");
    }

    public String getId() {
        return ID;
    }

    public String getBuilderId() {
        return null;
    }

    public IValidatingProjectTree getValidatingProjects(IProject project) {
        IProjectValidationContext rootContext = this.contexts.get(project);
        if (rootContext == null) {
            rootContext = new ProjectValidationContext();
            this.contexts.put(project, rootContext);
        }
        HashSet<IProject> projects = new HashSet<IProject>();
        projects.add(project);
        ValidatingProjectSet projectSet = new ValidatingProjectSet(project, projects, rootContext);
        return new SimpleValidatingProjectTree((IValidatingProjectSet)projectSet);
    }

    public boolean shouldValidate(IProject project) {
        if (!project.isAccessible()) {
            return false;
        }
        try {
            IFacetedProject fp = ProjectFacetsManager.create((IProject)project);
            IProjectFacet f = ProjectFacetsManager.getProjectFacet((String)"jst.web");
            if (fp != null && f != null && fp.getInstalledVersion(f) != null) {
                return true;
            }
        }
        catch (CoreException e) {
            WebModelPlugin.getDefault().logError(e);
        }
        return false;
    }

    public void init(IProject project, ContextValidationHelper validationHelper, IProjectValidationContext context, IValidator manager, IReporter reporter) {
        super.init(project, validationHelper, context, manager, reporter);
        this.projectName = project.getName();
    }

    public IStatus validate(Set<IFile> changedFiles, IProject project, ContextValidationHelper validationHelper, IProjectValidationContext context, ValidatorManager manager, IReporter reporter) throws ValidationException {
        this.init(project, validationHelper, context, (IValidator)manager, reporter);
        for (IFile file : changedFiles) {
            XModelObject o;
            if (!file.getName().endsWith(XML_EXT) || (o = EclipseResourceUtil.createObjectForResource((IResource)file)) == null || !o.getModelEntity().getName().startsWith("FileWebApp")) continue;
            this.validateWebXMLFile(o, file);
        }
        return this.OK_STATUS;
    }

    private void validateWebXMLFile(XModelObject object, IFile file) {
        this.validateObject(object);
    }

    private void validateObject(XModelObject object) {
        XModelObject[] cs;
        String entity = object.getModelEntity().getName();
        Set<Check> ch = this.checks.get(entity);
        if (ch != null) {
            for (Check c : ch) {
                c.check(object);
            }
        }
        XModelObject[] xModelObjectArray = cs = object.getChildren();
        int n = cs.length;
        int n2 = 0;
        while (n2 < n) {
            XModelObject c = xModelObjectArray[n2];
            this.validateObject(c);
            ++n2;
        }
    }

    public IStatus validateAll(IProject project, ContextValidationHelper validationHelper, IProjectValidationContext context, ValidatorManager manager, IReporter reporter) throws ValidationException {
        this.init(project, validationHelper, context, (IValidator)manager, reporter);
        this.displaySubtask(WebXMLValidatorMessages.VALIDATING_PROJECT, new String[]{this.projectName});
        IPath webContentPath = WebUtils.getFirstWebContentPath((IProject)project);
        if (webContentPath == null) {
            return this.OK_STATUS;
        }
        IFolder webInf = null;
        try {
            webInf = project.getFolder(webContentPath.removeFirstSegments(1).append("WEB-INF"));
            if (webInf.isAccessible()) {
                IResource[] rs;
                IResource[] iResourceArray = rs = webInf.members();
                int n = rs.length;
                int n2 = 0;
                while (n2 < n) {
                    XModelObject o;
                    IFile file;
                    String name;
                    IResource r = iResourceArray[n2];
                    if (r instanceof IFile && (name = (file = (IFile)r).getName()).endsWith(XML_EXT) && (o = EclipseResourceUtil.createObjectForResource((IResource)file)) != null && o.getModelEntity().getName().startsWith("FileWebApp")) {
                        this.validateWebXMLFile(o, file);
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException e) {
            return new Status(4, "org.jboss.tools.jst.web", MessageFormat.format("Validation error for project {0}", project.getLocation().toString()), (Throwable)e);
        }
        return this.OK_STATUS;
    }

    public boolean isEnabled(IProject project) {
        return WebXMLPreferences.isValidationEnabled(project);
    }

    public void registerPreferenceInfo() {
        PreferenceInfoManager.register((String)this.getProblemType(), (IPreferenceInfo)new WebXMLPreferenceInfo());
    }

    class WebXMLPreferenceInfo
    implements IPreferenceInfo {
        WebXMLPreferenceInfo() {
        }

        public String getPreferencePageId() {
            return WebXMLCoreValidator.PREFERENCE_PAGE_ID;
        }

        public String getPropertyPageId() {
            return WebXMLCoreValidator.PROPERTY_PAGE_ID;
        }

        public String getPluginId() {
            return "org.jboss.tools.jst.web";
        }
    }
}

