/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.webapp.model.handlers;

import java.util.Properties;
import org.jboss.tools.common.meta.action.impl.AbstractHandler;
import org.jboss.tools.common.meta.action.impl.SpecialWizardSupport;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.plugin.ModelMessages;
import org.jboss.tools.common.model.util.FindObjectHelper;
import org.jboss.tools.jst.web.model.helpers.WebAppHelper;
import org.jboss.tools.jst.web.webapp.model.WebAppConstants;

public class OpenRoleHandler
extends AbstractHandler
implements WebAppConstants {
    public boolean isEnabled(XModelObject object) {
        return object != null && object.getAttributeValue(this.getRoleAttribute()) != null && object.getAttributeValue(this.getRoleAttribute()).length() > 0;
    }

    public void executeHandler(XModelObject object, Properties p) throws XModelException {
        if (!this.isEnabled(object)) {
            return;
        }
        XModelObject webxml = FileSystemsHelper.getFile((XModelObject)object);
        if (webxml != null) {
            String roleName = object.getAttributeValue(this.getRoleAttribute());
            XModelObject role = WebAppHelper.findRole(webxml, roleName);
            if (role != null) {
                FindObjectHelper.findModelObject((XModelObject)role, (int)FindObjectHelper.IN_EDITOR_ONLY);
            } else {
                String message = "Cannot find role " + roleName;
                object.getModel().getService().showDialog(ModelMessages.WARNING, message, new String[]{SpecialWizardSupport.CLOSE}, null, 2);
            }
        }
    }

    private String getRoleAttribute() {
        String attribute = this.action.getProperty("attribute");
        if (attribute != null) {
            return attribute;
        }
        return "role-name";
    }
}

