/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.livereload.core.internal.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.jboss.tools.livereload.core.internal.JBossLiveReloadCoreActivator;

public final class Logger {
    private static final String INFO = "org.jboss.tools.livereload.core/info";
    private static final String DEBUG = "org.jboss.tools.livereload.core/debug";
    private static final String TRACE = "org.jboss.tools.livereload.core/trace";
    private static final ThreadLocal<DateFormat> dateFormatter = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("HH:mm:ss.SSS");
        }
    };

    private Logger() {
    }

    public static IStatus error(String message, Throwable t) {
        if (JBossLiveReloadCoreActivator.getDefault() != null) {
            Status status = new Status(4, "org.jboss.tools.livereload.core", message, t);
            JBossLiveReloadCoreActivator.getDefault().getLog().log((IStatus)status);
            return status;
        }
        t.printStackTrace();
        return null;
    }

    public static void error(String message) {
        JBossLiveReloadCoreActivator.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.tools.livereload.core", message));
    }

    public static void warn(String message, Throwable t) {
        JBossLiveReloadCoreActivator.getDefault().getLog().log((IStatus)new Status(2, "org.jboss.tools.livereload.core", message, t));
    }

    public static void warn(String message) {
        JBossLiveReloadCoreActivator.getDefault().getLog().log((IStatus)new Status(2, "org.jboss.tools.livereload.core", message));
    }

    public static void info(String message) {
        if (Logger.isOptionEnabled(INFO)) {
            JBossLiveReloadCoreActivator.getDefault().getLog().log((IStatus)new Status(1, "org.jboss.tools.livereload.core", message));
        }
    }

    public static void info(String message, Object ... items) {
        Logger.log(INFO, message, items);
    }

    public static void debug(String message) {
        Logger.debug(message, null);
    }

    public static void debug(String message, Object ... items) {
        Logger.log(DEBUG, message, items);
    }

    public static void trace(String message, Object ... items) {
        Logger.log(TRACE, message, items);
    }

    /*
     * Unable to fully structure code
     */
    private static void log(String level, String message, Object ... items) {
        block5: {
            try {
                if (!Logger.isOptionEnabled(level)) break block5;
                valuedMessage = message;
                if (items != null) {
                    var7_5 = items;
                    var6_7 = items.length;
                    var5_9 = 0;
                    while (var5_9 < var6_7) {
                        item = var7_5[var5_9];
                        valuedMessage = valuedMessage.replaceFirst("\\{\\}", item != null ? item.toString().replaceAll("\\$", ".") : "null");
                        ++var5_9;
                    }
                }
                System.out.println(String.valueOf(Logger.dateFormatter.get().format(new Date())) + " [" + Thread.currentThread().getName() + "] " + level.substring(level.indexOf("/") + 1).toUpperCase() + " " + valuedMessage);
                break block5;
            }
            catch (RuntimeException e) {
                System.err.println("Failed to write proper debug message with template:\n " + message + "\n and items:");
                var7_6 = items;
                var6_8 = items.length;
                var5_10 = 0;
                ** while (var5_10 < var6_8)
            }
lbl-1000:
            // 1 sources

            {
                item = var7_6[var5_10];
                System.err.println(" " + item);
                ++var5_10;
                continue;
            }
        }
    }

    private static boolean isOptionEnabled(String level) {
        String debugOption = Platform.getDebugOption((String)level);
        return JBossLiveReloadCoreActivator.getDefault() != null && JBossLiveReloadCoreActivator.getDefault().isDebugging() && "true".equalsIgnoreCase(debugOption);
    }

    public static boolean isDebugEnabled() {
        return Logger.isOptionEnabled(DEBUG);
    }
}

