/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.apt.internal.compiler;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import org.apache.maven.plugin.MojoExecution;
import org.codehaus.plexus.util.Scanner;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.configurator.MojoExecutionBuildParticipant;
import org.sonatype.plexus.build.incremental.BuildContext;

public class MavenCompilerBuildParticipant
extends MojoExecutionBuildParticipant {
    private static final String PROC = "proc";

    public MavenCompilerBuildParticipant(MojoExecution execution) {
        super(execution, true);
    }

    public Set<IProject> build(int kind, IProgressMonitor monitor) throws Exception {
        boolean isAnnotationProcessingEnabled;
        IMaven maven = MavenPlugin.getMaven();
        BuildContext buildContext = this.getBuildContext();
        MojoExecution mojoExecution = this.getMojoExecution();
        monitor.setTaskName("Executing " + mojoExecution.getArtifactId() + ":" + mojoExecution.getGoal());
        String compilerArgument = (String)maven.getMojoParameterValue(this.getSession(), mojoExecution, "compilerArgument", String.class);
        boolean bl = isAnnotationProcessingEnabled = compilerArgument == null || !compilerArgument.contains("-proc:none");
        if (isAnnotationProcessingEnabled) {
            String proc = (String)maven.getMojoParameterValue(this.getSession(), mojoExecution, PROC, String.class);
            boolean bl2 = isAnnotationProcessingEnabled = !"none".equals(proc);
        }
        if (!isAnnotationProcessingEnabled) {
            return Collections.emptySet();
        }
        IMavenProjectFacade mavenProjectFacade = this.getMavenProjectFacade();
        if (!buildContext.hasDelta(mavenProjectFacade.getPomFile())) {
            IPath[] sources = "compile".equals(mojoExecution.getGoal()) ? mavenProjectFacade.getCompileSourceLocations() : mavenProjectFacade.getTestCompileSourceLocations();
            boolean hasSourceChanged = false;
            IPath[] iPathArray = sources;
            int n = sources.length;
            int n2 = 0;
            while (n2 < n) {
                IPath relPathSource = iPathArray[n2];
                IFolder sourceFolder = mavenProjectFacade.getProject().getFolder(relPathSource);
                File folder = new File(sourceFolder.getRawLocationURI());
                Scanner ds = buildContext.newScanner(folder);
                ds.scan();
                String[] includedFiles = ds.getIncludedFiles();
                if (includedFiles != null && includedFiles.length > 0) {
                    hasSourceChanged = true;
                    break;
                }
                ++n2;
            }
            if (!hasSourceChanged) {
                return Collections.emptySet();
            }
        }
        Xpp3Dom originalConfiguration = mojoExecution.getConfiguration();
        Set result = Collections.emptySet();
        try {
            Xpp3Dom newConfiguration = new Xpp3Dom(originalConfiguration);
            this.setProcOnly(newConfiguration);
            this.setVerbose(newConfiguration);
            mojoExecution.setConfiguration(newConfiguration);
            result = super.build(kind, monitor);
        }
        finally {
            mojoExecution.setConfiguration(originalConfiguration);
        }
        File generated = (File)maven.getMojoParameterValue(this.getSession(), this.getMojoExecution(), "generatedSourcesDirectory", File.class);
        if (generated != null) {
            buildContext.refresh(generated);
        }
        return result;
    }

    private void setVerbose(Xpp3Dom configuration) {
        Xpp3Dom verboseDom = configuration.getChild("verbose");
        if (verboseDom == null) {
            verboseDom = new Xpp3Dom("verbose");
            configuration.addChild(verboseDom);
        }
        verboseDom.setValue("true");
    }

    private void setProcOnly(Xpp3Dom configuration) {
        Xpp3Dom procDom = configuration.getChild(PROC);
        if (procDom == null) {
            procDom = new Xpp3Dom(PROC);
            configuration.addChild(procDom);
        }
        procDom.setValue("only");
    }
}

