/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.apt.internal.compiler;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.m2e.core.internal.markers.IMavenMarkerManager;
import org.eclipse.m2e.core.internal.markers.MavenProblemInfo;
import org.eclipse.m2e.core.internal.markers.SourceLocation;
import org.eclipse.m2e.core.internal.markers.SourceLocationHelper;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.maven.apt.internal.AbstractAptConfiguratorDelegate;
import org.jboss.tools.maven.apt.internal.AnnotationProcessorConfiguration;
import org.jboss.tools.maven.apt.internal.DefaultAnnotationProcessorConfiguration;
import org.jboss.tools.maven.apt.internal.Messages;
import org.jboss.tools.maven.apt.internal.utils.PluginDependencyResolver;
import org.jboss.tools.maven.apt.internal.utils.ProjectUtils;

public class MavenCompilerJdtAptDelegate
extends AbstractAptConfiguratorDelegate {
    private static final String COMPILER_PLUGIN_GROUP_ID = "org.apache.maven.plugins";
    private static final String COMPILER_PLUGIN_ARTIFACT_ID = "maven-compiler-plugin";
    private static final String GOAL_COMPILE = "compile";
    static final String OUTPUT_DIRECTORY_PARAMETER = "generatedSourcesDirectory";
    protected IMavenMarkerManager markerManager;

    public MavenCompilerJdtAptDelegate(IMavenMarkerManager markerManager) {
        this.markerManager = markerManager;
    }

    @Override
    public boolean isIgnored(IProgressMonitor monitor) {
        try {
            return !this.mavenFacade.getMojoExecutions("org.bsc.maven", "maven-processor-plugin", monitor, new String[]{"process"}).isEmpty();
        }
        catch (CoreException ex) {
            ex.printStackTrace();
            return true;
        }
    }

    @Override
    protected AnnotationProcessorConfiguration getAnnotationProcessorConfiguration(IProgressMonitor monitor) throws CoreException {
        this.markerManager.deleteMarkers((IResource)this.mavenFacade.getProject(), true, "org.jboss.tools.maven.apt.problem.invalidArgument");
        MavenProject mavenProject = this.mavenFacade.getMavenProject(monitor);
        Iterator iterator = this.mavenFacade.getMojoExecutions(COMPILER_PLUGIN_GROUP_ID, COMPILER_PLUGIN_ARTIFACT_ID, monitor, new String[]{GOAL_COMPILE}).iterator();
        if (iterator.hasNext()) {
            Dependency[] annotationProcessorPaths;
            boolean isAnnotationProcessingEnabled;
            MojoExecution mojoExecution = (MojoExecution)iterator.next();
            File generatedOutputDirectory = (File)this.maven.getMojoParameterValue(mavenProject, mojoExecution, OUTPUT_DIRECTORY_PARAMETER, File.class, monitor);
            HashMap<String, String> options = new HashMap<String, String>();
            Map compilerArguments = (Map)this.maven.getMojoParameterValue(mavenProject, mojoExecution, "compilerArguments", Map.class, monitor);
            options.putAll(ProjectUtils.extractProcessorOptions(compilerArguments));
            String compilerArgument = (String)this.maven.getMojoParameterValue(mavenProject, mojoExecution, "compilerArgument", String.class, monitor);
            options.putAll(ProjectUtils.parseProcessorOptions(compilerArgument));
            List compilerArgs = (List)this.maven.getMojoParameterValue(mavenProject, mojoExecution, "compilerArgs", List.class, monitor);
            options.putAll(ProjectUtils.parseProcessorOptions(compilerArgs));
            this.sanitizeOptionNames(options.keySet(), mojoExecution);
            boolean bl = isAnnotationProcessingEnabled = compilerArgument == null || !compilerArgument.contains("-proc:none");
            if (isAnnotationProcessingEnabled) {
                String proc = (String)this.maven.getMojoParameterValue(mavenProject, mojoExecution, "proc", String.class, monitor);
                isAnnotationProcessingEnabled = !"none".equals(proc);
            }
            final boolean hasAnnotationProcessorPaths = (annotationProcessorPaths = (Dependency[])this.maven.getMojoParameterValue(mavenProject, mojoExecution, "annotationProcessorPaths", Dependency[].class, monitor)).length > 0;
            PluginDependencyResolver dependencyResolver = new PluginDependencyResolver(){

                @Override
                protected Collection<Dependency> getDependencies(Plugin plugin) {
                    return hasAnnotationProcessorPaths ? Arrays.asList(annotationProcessorPaths) : super.getDependencies(plugin);
                }
            };
            List<File> dependencies = dependencyResolver.getResolvedPluginDependencies(this.mavenSession, this.mavenFacade.getMavenProject(), mojoExecution.getPlugin(), monitor);
            DefaultAnnotationProcessorConfiguration configuration = new DefaultAnnotationProcessorConfiguration();
            configuration.setOutputDirectory(generatedOutputDirectory);
            configuration.setAnnotationProcessingEnabled(isAnnotationProcessingEnabled);
            configuration.setAddProjectDependencies(!hasAnnotationProcessorPaths);
            configuration.setDependencies(dependencies);
            configuration.setAnnotationProcessorOptions(options);
            return configuration;
        }
        return null;
    }

    private void sanitizeOptionNames(Set<String> optionNames, MojoExecution mojoExecution) throws CoreException {
        if (optionNames.isEmpty()) {
            return;
        }
        Iterator<String> iter = optionNames.iterator();
        SourceLocation location = SourceLocationHelper.findLocation((MavenProject)this.mavenFacade.getMavenProject((IProgressMonitor)new NullProgressMonitor()), (MojoExecutionKey)new MojoExecutionKey(mojoExecution));
        while (iter.hasNext()) {
            String optionName = iter.next();
            if (ProjectUtils.isValidOptionName(optionName)) continue;
            this.markerManager.addErrorMarker((IResource)this.mavenFacade.getPom(), "org.jboss.tools.maven.apt.problem.invalidArgument", new MavenProblemInfo(NLS.bind((String)Messages.ProjectUtils_error_invalid_option_name, (Object)optionName), location));
            iter.remove();
        }
    }
}

