/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.conversion.core.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.m2e.jdt.internal.MavenClasspathHelpers;
import org.jboss.tools.maven.conversion.core.DependencyCollector;
import org.jboss.tools.maven.conversion.core.ProjectDependency;
import org.jboss.tools.maven.conversion.core.internal.JavaDependency;

public class JavaDependencyCollector
extends DependencyCollector {
    @Override
    public List<ProjectDependency> collectDependencies(IProject project) throws CoreException {
        if (!this.appliesTo(project)) {
            return null;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null) {
            return null;
        }
        IClasspathEntry[] classpath = javaProject.getRawClasspath();
        ArrayList<ProjectDependency> classpathDependencies = new ArrayList<ProjectDependency>(classpath.length);
        this.extractDependencies(javaProject, classpath, classpathDependencies);
        return classpathDependencies;
    }

    private void extractDependencies(IJavaProject javaProject, IClasspathEntry[] classpath, List<ProjectDependency> classpathDependencies) throws JavaModelException {
        IClasspathEntry[] iClasspathEntryArray = classpath;
        int n = classpath.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry cpe = iClasspathEntryArray[n2];
            if (this.isValid(cpe)) {
                if (cpe.getEntryKind() == 5) {
                    IClasspathEntry[] cpes;
                    IClasspathContainer container = JavaCore.getClasspathContainer((IPath)cpe.getPath(), (IJavaProject)javaProject);
                    if (container != null && (cpes = container.getClasspathEntries()) != null && cpes.length > 0) {
                        this.extractDependencies(javaProject, cpes, classpathDependencies);
                    }
                } else {
                    classpathDependencies.add(new JavaDependency(cpe));
                }
            }
            ++n2;
        }
    }

    @Override
    public boolean appliesTo(IProject project) throws CoreException {
        return project != null && project.hasNature("org.eclipse.jdt.core.javanature") && !project.hasNature("org.eclipse.pde.PluginNature");
    }

    private boolean isValid(IClasspathEntry cpe) {
        if (5 == cpe.getEntryKind() && ("org.eclipse.jdt.launching.JRE_CONTAINER".equals(cpe.getPath().segment(0)) || MavenClasspathHelpers.isMaven2ClasspathContainer((IPath)cpe.getPath()))) {
            return false;
        }
        return 3 != cpe.getEntryKind();
    }
}

