/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.conversion.ui.internal;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;

public class GenericCommandActionDelegate
implements IWorkbenchWindowActionDelegate,
IViewActionDelegate,
IEditorActionDelegate,
IObjectActionDelegate,
IExecutableExtension {
    public static final String PARM_COMMAND_ID = "commandId";
    private String commandId = null;
    private Map<?, ?> parameterMap = null;
    private ParameterizedCommand parameterizedCommand = null;
    private IHandlerService handlerService = null;

    public void dispose() {
        this.handlerService = null;
        this.parameterizedCommand = null;
        this.parameterMap = null;
    }

    public void run(IAction action) {
        if (this.handlerService == null) {
            return;
        }
        try {
            if (this.commandId != null) {
                this.handlerService.executeCommand(this.commandId, null);
            } else if (this.parameterizedCommand != null) {
                this.handlerService.executeCommand(this.parameterizedCommand, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        String id = config.getAttribute("id");
        if (data instanceof String) {
            this.commandId = (String)data;
        } else if (data instanceof Map) {
            this.parameterMap = (Map)data;
            if (this.parameterMap.get(PARM_COMMAND_ID) == null) {
                Status status = new Status(4, "org.jboss.tools.maven.ui.generic", "The '" + id + "' action won't work without a commandId");
                throw new CoreException((IStatus)status);
            }
        } else {
            Status status = new Status(4, "org.jboss.tools.maven.ui.generic", "The '" + id + "' action won't work without some initialization parameters");
            throw new CoreException((IStatus)status);
        }
    }

    private void createCommand(ICommandService commandService) {
        String id = (String)this.parameterMap.get(PARM_COMMAND_ID);
        if (id == null) {
            return;
        }
        if (this.parameterMap.size() == 1) {
            this.commandId = id;
            return;
        }
        try {
            Command cmd = commandService.getCommand(id);
            if (!cmd.isDefined()) {
                return;
            }
            ArrayList<Parameterization> parameters = new ArrayList<Parameterization>();
            for (String parmName : this.parameterMap.keySet()) {
                if (PARM_COMMAND_ID.equals(parmName)) continue;
                IParameter parm = cmd.getParameter(parmName);
                if (parm == null) {
                    return;
                }
                parameters.add(new Parameterization(parm, (String)this.parameterMap.get(parmName)));
            }
            this.parameterizedCommand = new ParameterizedCommand(cmd, parameters.toArray(new Parameterization[parameters.size()]));
        }
        catch (NotDefinedException notDefinedException) {
            // empty catch block
        }
    }

    public void init(IWorkbenchWindow window) {
        if (this.handlerService != null) {
            return;
        }
        this.handlerService = (IHandlerService)window.getService(IHandlerService.class);
        if (this.parameterMap != null) {
            ICommandService commandService = (ICommandService)window.getService(ICommandService.class);
            this.createCommand(commandService);
        }
    }

    public void init(IViewPart view) {
        this.init(view.getSite().getWorkbenchWindow());
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        if (targetEditor != null) {
            this.init(targetEditor.getSite().getWorkbenchWindow());
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        if (targetPart != null) {
            this.init(targetPart.getSite().getWorkbenchWindow());
        }
    }
}

