/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.model.Build;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.common.project.facet.core.internal.JavaFacetUtil;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderOperationConfig;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.MavenModelManager;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.jdt.internal.BuildPathManager;
import org.eclipse.m2e.model.edit.pom.Dependency;
import org.eclipse.m2e.model.edit.pom.DependencyManagement;
import org.eclipse.m2e.model.edit.pom.Model;
import org.eclipse.m2e.model.edit.pom.PomFactory;
import org.eclipse.m2e.model.edit.pom.PropertyElement;
import org.eclipse.m2e.model.edit.pom.Repository;
import org.eclipse.m2e.model.edit.pom.util.PomResourceFactoryImpl;
import org.eclipse.m2e.model.edit.pom.util.PomResourceImpl;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.jboss.tools.maven.core.IArtifactResolutionService;
import org.jboss.tools.maven.core.internal.resolution.ArtifactResolutionService;
import org.jboss.tools.maven.core.repositories.RemoteRepositoryManager;
import org.jboss.tools.maven.core.settings.MavenSettingsChangeListener;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;

public class MavenCoreActivator
extends Plugin {
    private static final String ROOT_DIR = "/";
    public static final String SEPARATOR = "/";
    public static final String PLUGIN_ID = "org.jboss.tools.maven.core";
    public static final String OWNER_PROJECT_FACETS_ATTR = "owner.project.facets";
    public static final String BASEDIR = "${basedir}";
    public static final String ENCODING = "UTF-8";
    public static final List<LibraryProviderOperationConfig> libraryProviderOperationConfigs = new ArrayList<LibraryProviderOperationConfig>();
    private static final String DEFAULT_COMPILER_LEVEL = "1.5";
    private static final String DEFAULT_WEBCONTENT_ROOT = "src/main/webapp";
    private static MavenCoreActivator plugin;
    private static PomResourceImpl resource;
    private IArtifactResolutionService artifactResolutionService;
    private RemoteRepositoryManager repositoryManager;
    private Set<MavenSettingsChangeListener> mavenSettingsListeners = Collections.newSetFromMap(new ConcurrentHashMap());

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.mavenSettingsListeners.clear();
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        this.artifactResolutionService = null;
        plugin = null;
        this.mavenSettingsListeners.clear();
        super.stop(context);
    }

    public static MavenCoreActivator getDefault() {
        return plugin;
    }

    public static IStatus getStatus(String message) {
        return new Status(4, PLUGIN_ID, message);
    }

    public static IStatus getStatus(String message, Throwable e) {
        return new Status(4, PLUGIN_ID, message, e);
    }

    public static IProject createMavenProject(String projectName, IProgressMonitor monitor, org.apache.maven.model.Model model, boolean force) throws CoreException {
        return MavenCoreActivator.createMavenProject(projectName, monitor, model, force, null);
    }

    public static IProject createMavenProject(String projectName, IProgressMonitor monitor, org.apache.maven.model.Model model, boolean force, IPath location) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        if (project.exists() && !force) {
            return project;
        }
        if (!project.exists()) {
            if (location != null) {
                IPath workspacePath = project.getWorkspace().getRoot().getLocation();
                if (projectName.equals((location = location.makeRelativeTo(workspacePath)).toString())) {
                    project.create(monitor);
                } else {
                    IProjectDescription desc = project.getWorkspace().newProjectDescription(project.getName());
                    desc.setLocation(location);
                    project.create(desc, monitor);
                }
            } else {
                project.create(monitor);
            }
            project.open(monitor);
        }
        MavenCoreActivator.addMavenCapabilities(project, monitor, model);
        return project;
    }

    public static void addMavenCapabilities(IProject project, IProgressMonitor monitor, org.apache.maven.model.Model model) throws CoreException {
        IFile pom = project.getFile("pom.xml");
        if (!pom.exists() && model != null) {
            MavenModelManager modelManager = MavenPlugin.getMavenModelManager();
            modelManager.createMavenModel(pom, model);
        }
        boolean hasMavenNature = MavenCoreActivator.addMavenNature(project, monitor);
        boolean hasJavaNature = project.hasNature("org.eclipse.jdt.core.javanature");
        if (!hasMavenNature && hasJavaNature) {
            IClasspathAttribute attribute = JavaCore.newClasspathAttribute((String)OWNER_PROJECT_FACETS_ATTR, (String)"jboss.m2");
            IJavaProject javaProject = JavaCore.create((IProject)project);
            MavenCoreActivator.addClasspathAttribute(javaProject, attribute, monitor);
            MavenCoreActivator.updateMavenProjectConfiguration(project);
        }
    }

    public static boolean addMavenNature(IProject project, IProgressMonitor monitor) throws CoreException {
        IJavaProject javaProject;
        IClasspathContainer mavenContainer;
        boolean hasJavaNature;
        boolean hasMavenNature = project.hasNature("org.eclipse.m2e.core.maven2Nature");
        if (!hasMavenNature) {
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length + 1];
            System.arraycopy(prevNatures, 0, newNatures, 1, prevNatures.length);
            newNatures[0] = "org.eclipse.m2e.core.maven2Nature";
            description.setNatureIds(newNatures);
            project.setDescription(description, monitor);
        }
        if ((hasJavaNature = project.hasNature("org.eclipse.jdt.core.javanature")) && (mavenContainer = BuildPathManager.getMaven2ClasspathContainer((IJavaProject)(javaProject = JavaCore.create((IProject)project)))) == null) {
            Path path = new Path("org.eclipse.m2e.MAVEN2_CLASSPATH_CONTAINER");
            MavenCoreActivator.setContainerPath(monitor, javaProject, (IPath)path);
        }
        return hasMavenNature;
    }

    public static String getSourceDirectory(IJavaProject javaProject) throws JavaModelException {
        IClasspathEntry[] entries = javaProject.getRawClasspath();
        IPath path = null;
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getEntryKind() == 3) {
                path = entries[i].getPath();
                break;
            }
            ++i;
        }
        if (path == null) {
            return null;
        }
        String value = (path = path.makeRelativeTo(javaProject.getPath())).toString();
        if (value.startsWith("/")) {
            return BASEDIR + path.toString();
        }
        return "${basedir}/" + path.toString();
    }

    public static void addClasspathAttribute(IJavaProject javaProject, IClasspathAttribute attribute, IProgressMonitor monitor) throws JavaModelException {
        if (javaProject == null || !javaProject.exists()) {
            return;
        }
        IClasspathEntry[] cp = javaProject.getRawClasspath();
        int i = 0;
        while (i < cp.length) {
            if (5 == cp[i].getEntryKind() && cp[i].getPath() != null && cp[i].getPath().segmentCount() > 0 && "org.eclipse.m2e.MAVEN2_CLASSPATH_CONTAINER".equals(cp[i].getPath().segment(0))) {
                LinkedHashMap<String, IClasspathAttribute> attrs = new LinkedHashMap<String, IClasspathAttribute>();
                IClasspathAttribute[] iClasspathAttributeArray = cp[i].getExtraAttributes();
                int n = iClasspathAttributeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathAttribute attr = iClasspathAttributeArray[n2];
                    attrs.put(attr.getName(), attr);
                    ++n2;
                }
                attrs.put(attribute.getName(), attribute);
                IClasspathAttribute[] newAttrs = attrs.values().toArray(new IClasspathAttribute[attrs.size()]);
                cp[i] = JavaCore.newContainerEntry((IPath)cp[i].getPath(), (IAccessRule[])cp[i].getAccessRules(), (IClasspathAttribute[])newAttrs, (boolean)cp[i].isExported());
                break;
            }
            ++i;
        }
        javaProject.setRawClasspath(cp, monitor);
    }

    public static void setContainerPath(IProgressMonitor monitor, IJavaProject javaProject, IPath containerPath) throws CoreException {
        IClasspathEntry entry = JavaCore.newContainerEntry((IPath)containerPath, (boolean)false);
        IClasspathEntry[] entries = javaProject.getRawClasspath();
        IClasspathEntry[] newEntries = new IClasspathEntry[entries.length + 1];
        System.arraycopy(entries, 0, newEntries, 0, entries.length);
        newEntries[entries.length] = entry;
        javaProject.setRawClasspath(newEntries, monitor);
    }

    public static void updateMavenProjectConfiguration(IProject project) throws CoreException {
        IProjectConfigurationManager configurationManager = MavenPlugin.getProjectConfigurationManager();
        configurationManager.updateProjectConfiguration(project, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void addMavenWarPlugin(Build build, IProject project, IProjectFacetVersion webFacetversion) throws JavaModelException {
        boolean needsFailOnMissingWebXml;
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component == null) {
            return;
        }
        IVirtualFolder rootFolder = component.getRootFolder();
        IContainer root = rootFolder.getUnderlyingFolder();
        String webContentRoot = root.getProjectRelativePath().toString();
        boolean isDefaultWarSource = DEFAULT_WEBCONTENT_ROOT.equals(webContentRoot);
        boolean bl = needsFailOnMissingWebXml = webFacetversion != null && JavaEEProjectUtilities.DYNAMIC_WEB_25.compareTo((Object)webFacetversion) < 1;
        if (isDefaultWarSource && !needsFailOnMissingWebXml) {
            return;
        }
        org.apache.maven.model.Plugin plugin = new org.apache.maven.model.Plugin();
        plugin.setGroupId("org.apache.maven.plugins");
        plugin.setArtifactId("maven-war-plugin");
        plugin.setVersion("2.3");
        Xpp3Dom configuration = new Xpp3Dom("configuration");
        if (!isDefaultWarSource) {
            Xpp3Dom warSourceDirectory = new Xpp3Dom("warSourceDirectory");
            if (webContentRoot.startsWith("/")) {
                warSourceDirectory.setValue(BASEDIR + webContentRoot);
            } else {
                warSourceDirectory.setValue("${basedir}/" + webContentRoot);
            }
            configuration.addChild(warSourceDirectory);
        }
        if (needsFailOnMissingWebXml) {
            Xpp3Dom failOnMissingWebXml = new Xpp3Dom("failOnMissingWebXml");
            failOnMissingWebXml.setValue("false");
            configuration.addChild(failOnMissingWebXml);
        }
        plugin.setConfiguration((Object)configuration);
        build.getPlugins().add(plugin);
    }

    public static void addResource(Build build, IProject project, String sourceDirectory) throws JavaModelException {
        IJavaProject javaProject;
        org.apache.maven.model.Resource resource = new org.apache.maven.model.Resource();
        if (sourceDirectory == null && (javaProject = JavaCore.create((IProject)project)) != null && javaProject.exists()) {
            sourceDirectory = MavenCoreActivator.getSourceDirectory(javaProject);
        }
        if (sourceDirectory != null) {
            resource.setDirectory(sourceDirectory);
            ArrayList<String> excludes = new ArrayList<String>();
            excludes.add("**/*.java");
            resource.setExcludes(excludes);
        }
        build.getResources().add(resource);
    }

    public static void addMavenEarPlugin(Build build, IProject project, IDataModel m2FacetModel, String ejbArtifactId, IProjectFacetVersion earFacetVersion, boolean addSeamModules) throws JavaModelException {
        String sourceDirectory = MavenCoreActivator.getEarRoot(project);
        org.apache.maven.model.Plugin plugin = new org.apache.maven.model.Plugin();
        plugin.setGroupId("org.apache.maven.plugins");
        plugin.setArtifactId("maven-ear-plugin");
        plugin.setVersion("2.8");
        Xpp3Dom configuration = new Xpp3Dom("configuration");
        if (earFacetVersion != null) {
            String earVersion = earFacetVersion.getVersionString();
            if (earVersion.endsWith(".0")) {
                earVersion = "" + Double.valueOf(earVersion).intValue();
            }
            Xpp3Dom version = new Xpp3Dom("version");
            version.setValue(earVersion);
            configuration.addChild(version);
        }
        Xpp3Dom defaultLibBundleDir = new Xpp3Dom("defaultLibBundleDir");
        defaultLibBundleDir.setValue("lib");
        configuration.addChild(defaultLibBundleDir);
        if (!"src/main/application".equals(sourceDirectory)) {
            Xpp3Dom earSourceDirectory = new Xpp3Dom("earSourceDirectory");
            earSourceDirectory.setValue(sourceDirectory);
            configuration.addChild(earSourceDirectory);
        }
        if (addSeamModules) {
            Xpp3Dom modules = new Xpp3Dom("modules");
            configuration.addChild(modules);
            if (ejbArtifactId != null) {
                String ejbModuleName = String.valueOf(ejbArtifactId) + ".jar";
                Xpp3Dom ejbProject = MavenCoreActivator.getEarModule("ejbModule", m2FacetModel.getStringProperty("groupId"), ejbArtifactId, "/", ejbModuleName);
                modules.addChild(ejbProject);
            }
            String webModuleName = String.valueOf(m2FacetModel.getStringProperty("artifactId")) + ".war";
            Xpp3Dom webProject = MavenCoreActivator.getEarModule("webModule", m2FacetModel.getStringProperty("groupId"), m2FacetModel.getStringProperty("artifactId"), "/", webModuleName);
            Xpp3Dom contextRoot = new Xpp3Dom("contextRoot");
            contextRoot.setValue(m2FacetModel.getStringProperty("artifactId"));
            webProject.addChild(contextRoot);
            modules.addChild(webProject);
            Xpp3Dom richFacesApi = MavenCoreActivator.getEarModule("jarModule", "org.richfaces.framework", "richfaces-api", "/lib", null);
            modules.addChild(richFacesApi);
            Xpp3Dom commonDigester = MavenCoreActivator.getEarModule("jarModule", "commons-digester", "commons-digester", "/lib", null);
            modules.addChild(commonDigester);
        }
        plugin.setConfiguration((Object)configuration);
        build.getPlugins().add(plugin);
    }

    private static Xpp3Dom getEarModule(String module, String groupIdString, String artifactIdString, String bundleDirString, String bundleFileNameString) {
        Xpp3Dom earModule = new Xpp3Dom(module);
        Xpp3Dom groupId = new Xpp3Dom("groupId");
        groupId.setValue(groupIdString);
        earModule.addChild(groupId);
        Xpp3Dom artifactId = new Xpp3Dom("artifactId");
        artifactId.setValue(artifactIdString);
        earModule.addChild(artifactId);
        if (!"/".equals(bundleDirString)) {
            Xpp3Dom bundleDir = new Xpp3Dom("bundleDir");
            bundleDir.setValue(bundleDirString);
            earModule.addChild(bundleDir);
        }
        if (bundleFileNameString != null) {
            Xpp3Dom bundleFileName = new Xpp3Dom("bundleFileName");
            bundleFileName.setValue(bundleFileNameString);
            earModule.addChild(bundleFileName);
        }
        return earModule;
    }

    public static void addMavenEjbPlugin(Build build, IProject project, IProjectFacetVersion ejbFacetVersion) throws JavaModelException {
        String version;
        if (ejbFacetVersion != null && !"2.1".equals(version = ejbFacetVersion.getVersionString())) {
            org.apache.maven.model.Plugin plugin = new org.apache.maven.model.Plugin();
            plugin.setGroupId("org.apache.maven.plugins");
            plugin.setArtifactId("maven-ejb-plugin");
            plugin.setVersion("2.3");
            Xpp3Dom configuration = new Xpp3Dom("configuration");
            Xpp3Dom ejbVersion = new Xpp3Dom("ejbVersion");
            ejbVersion.setValue(version);
            configuration.addChild(ejbVersion);
            plugin.setConfiguration((Object)configuration);
            build.getPlugins().add(plugin);
        }
    }

    public static String getOutputDirectory(IJavaProject javaProject) throws CoreException {
        IPath path = javaProject.getOutputLocation();
        if ((path = path.makeRelativeTo(javaProject.getPath())) == null) {
            return null;
        }
        String value = path.toString();
        if (value.startsWith("/")) {
            return BASEDIR + path.toString();
        }
        return "${basedir}/" + path.toString();
    }

    public static String getEarRoot(IProject project) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        IVirtualFolder rootFolder = component.getRootFolder();
        IContainer root = rootFolder.getUnderlyingFolder();
        String sourceDirectory = root.getProjectRelativePath().toString();
        return sourceDirectory;
    }

    public static void mergeModel(Model projectModel, Model libraryModel) {
        if (projectModel == null || libraryModel == null) {
            return;
        }
        MavenCoreActivator.addProperties(projectModel, libraryModel);
        MavenCoreActivator.addRepositories(projectModel, libraryModel);
        MavenCoreActivator.addPlugins(projectModel, libraryModel);
        DependencyManagement depMgtProject = projectModel.getDependencyManagement();
        DependencyManagement depMgtLibrary = libraryModel.getDependencyManagement();
        if (depMgtLibrary != null && !depMgtLibrary.getDependencies().isEmpty()) {
            if (depMgtProject == null) {
                depMgtProject = PomFactory.eINSTANCE.createDependencyManagement();
                projectModel.setDependencyManagement(depMgtProject);
            }
            MavenCoreActivator.addDependencies((List<Dependency>)projectModel.getDependencyManagement().getDependencies(), (List<Dependency>)libraryModel.getDependencyManagement().getDependencies());
        }
        MavenCoreActivator.addDependencies((List<Dependency>)projectModel.getDependencies(), (List<Dependency>)libraryModel.getDependencies());
    }

    private static void addDependencies(List<Dependency> projectDependencies, List<Dependency> libraryDependencies) {
        for (Dependency dependency : libraryDependencies) {
            if (MavenCoreActivator.dependencyExists(dependency, projectDependencies)) continue;
            Dependency newDependency = (Dependency)EcoreUtil.copy((EObject)dependency);
            projectDependencies.add(newDependency);
        }
    }

    private static boolean dependencyExists(Dependency dependency, List<Dependency> projectDependencies) {
        String groupId = dependency.getGroupId();
        String artifactId = dependency.getArtifactId();
        if (artifactId == null) {
            return false;
        }
        for (Dependency projectDependency : projectDependencies) {
            String projectGroupId = projectDependency.getGroupId();
            String projectArtifactId = projectDependency.getArtifactId();
            if (!artifactId.equals(projectArtifactId)) {
                return false;
            }
            if (groupId == null && projectGroupId == null) {
                return true;
            }
            if (groupId == null || !groupId.equals(projectGroupId)) continue;
            return true;
        }
        return false;
    }

    private static void addPlugins(Model projectModel, Model libraryModel) {
        org.eclipse.m2e.model.edit.pom.Build libraryBuild = libraryModel.getBuild();
        if (libraryBuild == null) {
            return;
        }
        EList libraryPlugins = libraryModel.getBuild().getPlugins();
        for (org.eclipse.m2e.model.edit.pom.Plugin plugin : libraryPlugins) {
            EList projectPlugins;
            org.eclipse.m2e.model.edit.pom.Build projectBuild = projectModel.getBuild();
            if (projectBuild == null) {
                projectBuild = PomFactory.eINSTANCE.createBuild();
                projectModel.setBuild(projectBuild);
            }
            if (MavenCoreActivator.pluginExists(plugin, (List<org.eclipse.m2e.model.edit.pom.Plugin>)(projectPlugins = projectBuild.getPlugins()))) continue;
            org.eclipse.m2e.model.edit.pom.Plugin newPlugin = (org.eclipse.m2e.model.edit.pom.Plugin)EcoreUtil.copy((EObject)plugin);
            projectPlugins.add(newPlugin);
        }
    }

    private static boolean pluginExists(org.eclipse.m2e.model.edit.pom.Plugin plugin, List<org.eclipse.m2e.model.edit.pom.Plugin> projectPlugins) {
        String groupId = plugin.getGroupId();
        String artifactId = plugin.getArtifactId();
        if (artifactId == null) {
            return false;
        }
        for (org.eclipse.m2e.model.edit.pom.Plugin projectPlugin : projectPlugins) {
            String projectGroupId = projectPlugin.getGroupId();
            String projectArtifactId = projectPlugin.getArtifactId();
            if (!artifactId.equals(projectArtifactId)) {
                return false;
            }
            if (groupId == null && projectGroupId == null) {
                return true;
            }
            if (groupId == null || !groupId.equals(projectGroupId)) continue;
            return true;
        }
        return false;
    }

    private static void addRepositories(Model projectModel, Model libraryModel) {
        EList projectRepositories = projectModel.getRepositories();
        EList libraryRepositories = libraryModel.getRepositories();
        for (Repository repository : libraryRepositories) {
            if (MavenCoreActivator.repositoryExists(repository, (List<Repository>)projectRepositories)) continue;
            Repository newRepository = (Repository)EcoreUtil.copy((EObject)repository);
            projectRepositories.add(newRepository);
        }
    }

    private static boolean repositoryExists(Repository repository, List<Repository> projectRepositories) {
        String url = repository.getUrl();
        if (url == null) {
            return false;
        }
        for (Repository projectRepository : projectRepositories) {
            if (!url.equals(projectRepository.getUrl())) continue;
            return true;
        }
        return false;
    }

    private static void addProperties(Model projectModel, Model libraryModel) {
        EList projectProperties = projectModel.getProperties();
        EList libraryProperties = libraryModel.getProperties();
        for (PropertyElement libraryProperty : libraryProperties) {
            String propertyName = libraryProperty.getName();
            if (MavenCoreActivator.propertyExists(propertyName, (List<PropertyElement>)projectProperties)) continue;
            PropertyElement newProperty = (PropertyElement)EcoreUtil.copy((EObject)libraryProperty);
            projectProperties.add(newProperty);
        }
    }

    private static boolean propertyExists(String propertyName, List<PropertyElement> projectProperties) {
        if (propertyName == null) {
            return false;
        }
        for (PropertyElement propertyElement : projectProperties) {
            if (!propertyName.equals(propertyElement.getName())) continue;
            return true;
        }
        return false;
    }

    public static void log(Throwable e) {
        Status status = new Status(4, PLUGIN_ID, e.getLocalizedMessage(), e);
        MavenCoreActivator.getDefault().getLog().log((IStatus)status);
    }

    public static void log(String message) {
        Status status = new Status(4, PLUGIN_ID, message);
        MavenCoreActivator.getDefault().getLog().log((IStatus)status);
    }

    public static File getProviderFile(ILibraryProvider provider) {
        String id = provider.getId();
        IPath providerDir = MavenCoreActivator.getDefault().getStateLocation().append(id);
        File providerDirFile = providerDir.toFile();
        providerDirFile.mkdir();
        File providerFile = new File(providerDirFile, "template.xml");
        return providerFile;
    }

    public static PomResourceImpl loadResource(URL url) throws CoreException {
        try {
            URI uri = URI.createURI((String)url.toString());
            if (!uri.isFile() && !uri.isPlatformResource()) {
                InputStream is = null;
                OutputStream os = null;
                try {
                    try {
                        File temp = File.createTempFile("mavenCoreActivator", ".pom");
                        temp.deleteOnExit();
                        os = new FileOutputStream(temp);
                        is = url.openStream();
                        MavenCoreActivator.copy(is, os);
                        URL tempURL = temp.toURL();
                        uri = URI.createURI((String)tempURL.toString());
                    }
                    catch (Exception e) {
                        MavenCoreActivator.log(e);
                        throw new CoreException((IStatus)new Status(4, PLUGIN_ID, -1, e.getMessage(), (Throwable)e));
                    }
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            Resource resource = new PomResourceFactoryImpl().createResource(uri);
            resource.load(Collections.EMPTY_MAP);
            return (PomResourceImpl)resource;
        }
        catch (Exception ex) {
            MavenCoreActivator.log(ex);
            throw new CoreException((IStatus)new Status(4, PLUGIN_ID, -1, ex.getMessage(), (Throwable)ex));
        }
    }

    public static void copy(InputStream is, OutputStream os) throws IOException {
        int count;
        byte[] buffer = new byte[1024];
        while ((count = is.read(buffer)) > 0) {
            os.write(buffer, 0, count);
        }
    }

    public static void addLibraryProviderOperationConfig(LibraryProviderOperationConfig config) {
        libraryProviderOperationConfigs.add(config);
    }

    public static List<LibraryProviderOperationConfig> getLibraryProviderOperationConfigs() {
        return libraryProviderOperationConfigs;
    }

    public static PomResourceImpl getResource() {
        return resource;
    }

    public static void setResource(PomResourceImpl resource2) {
        resource = resource2;
    }

    public static void addCompilerPlugin(List<org.apache.maven.model.Plugin> plugins, IProject project) {
        String compilerLevel = JavaFacetUtil.getCompilerLevel((IProject)project);
        if (compilerLevel == null || DEFAULT_COMPILER_LEVEL.equals(compilerLevel)) {
            return;
        }
        org.apache.maven.model.Plugin plugin = new org.apache.maven.model.Plugin();
        plugin.setGroupId("org.apache.maven.plugins");
        plugin.setArtifactId("maven-compiler-plugin");
        plugin.setVersion("3.0");
        Xpp3Dom configuration = new Xpp3Dom("configuration");
        Xpp3Dom source = new Xpp3Dom("source");
        source.setValue(compilerLevel);
        configuration.addChild(source);
        Xpp3Dom target = new Xpp3Dom("target");
        target.setValue(compilerLevel);
        configuration.addChild(target);
        plugin.setConfiguration((Object)configuration);
        plugins.add(plugin);
    }

    public static PomResourceImpl loadResource(IFile pomFile) throws CoreException {
        String path = pomFile.getFullPath().toOSString();
        URI uri = URI.createPlatformResourceURI((String)path, (boolean)true);
        try {
            Resource pomResource = new PomResourceFactoryImpl().createResource(uri);
            pomResource.load(new HashMap());
            return (PomResourceImpl)pomResource;
        }
        catch (Exception ex) {
            String msg = "Can't load model " + pomFile;
            MavenCoreActivator.log(ex);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, msg, (Throwable)ex));
        }
    }

    public RemoteRepositoryManager getRepositoryManager() {
        if (this.repositoryManager == null) {
            this.repositoryManager = new RemoteRepositoryManager();
        }
        return this.repositoryManager;
    }

    public static IEclipsePreferences getPreferences() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
        return prefs;
    }

    public void savePreferences() {
        IEclipsePreferences prefs = MavenCoreActivator.getPreferences();
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            MavenCoreActivator.log(e);
        }
    }

    public void notifyMavenSettingsChanged() {
        for (MavenSettingsChangeListener mscl : this.mavenSettingsListeners) {
            try {
                mscl.onSettingsChanged();
            }
            catch (Exception e) {
                MavenCoreActivator.log(e);
            }
        }
    }

    public void registerMavenSettingsChangeListener(MavenSettingsChangeListener listener) {
        this.mavenSettingsListeners.add(listener);
    }

    public void unregisterMavenSettingsChangeListener(MavenSettingsChangeListener listener) {
        this.mavenSettingsListeners.remove(listener);
    }

    public IArtifactResolutionService getArtifactResolutionService() {
        if (this.artifactResolutionService == null) {
            this.artifactResolutionService = new ArtifactResolutionService();
        }
        return this.artifactResolutionService;
    }
}

