/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.core.internal.identification;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.internal.index.IIndex;
import org.eclipse.m2e.core.internal.index.IndexManager;
import org.eclipse.m2e.core.internal.index.IndexedArtifactFile;
import org.eclipse.m2e.core.internal.index.nexus.NexusIndex;
import org.eclipse.m2e.core.internal.index.nexus.NexusIndexManager;
import org.eclipse.m2e.core.repository.IRepository;
import org.eclipse.m2e.core.repository.IRepositoryRegistry;
import org.jboss.tools.maven.core.internal.identification.AbstractArtifactIdentifier;

public class NexusIndexIdentifier
extends AbstractArtifactIdentifier {
    private List<IRepository> globalRepositories = this.initGlobalRepositories();

    public NexusIndexIdentifier() {
        super("Nexus Index identifier");
    }

    @Override
    public ArtifactKey identify(File file) throws CoreException {
        return this.identify(file, null);
    }

    @Override
    public ArtifactKey identify(File file, IProgressMonitor monitor) throws CoreException {
        IndexedArtifactFile info;
        IIndex index;
        IndexManager indexManager;
        block10: {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            indexManager = MavenPlugin.getIndexManager();
            index = indexManager.getAllIndexes();
            info = null;
            if (!monitor.isCanceled()) break block10;
            return null;
        }
        try {
            monitor.setTaskName("Checking global m2e Nexus index for " + file.getName());
            info = index.identify(file);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ArtifactKey artifact = null;
        if (info != null && (artifact = info.getArtifactKey()) != null) {
            return artifact;
        }
        if (indexManager instanceof NexusIndexManager) {
            NexusIndexManager nexusIndexManager = (NexusIndexManager)indexManager;
            for (IRepository repository : this.globalRepositories) {
                NexusIndex nexusIndex;
                block11: {
                    nexusIndex = nexusIndexManager.getIndex(repository);
                    if (nexusIndex == null) continue;
                    if (!monitor.isCanceled()) break block11;
                    return null;
                }
                try {
                    monitor.setTaskName("Checking Nexus index of '" + repository.getId() + "' repository for " + file.getName());
                    info = nexusIndex.identify(file);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (info == null || (artifact = info.getArtifactKey()) == null) continue;
                return artifact;
            }
        }
        return artifact;
    }

    private List<IRepository> initGlobalRepositories() {
        IRepositoryRegistry repositoryRegistry = MavenPlugin.getRepositoryRegistry();
        List repositories = repositoryRegistry.getRepositories(8);
        return repositories == null ? Collections.emptyList() : repositories;
    }
}

