/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.core.repositories;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.eclipse.core.runtime.Assert;

public class NexusRepository {
    private String name;
    private String url;
    private boolean enabled;
    private static final String PATH_SEPARATOR = "/";

    public NexusRepository() {
    }

    public NexusRepository(String name, String url, boolean enabled) {
        this.name = name;
        this.url = url;
        this.enabled = enabled;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean checked) {
        this.enabled = checked;
    }

    public String toString() {
        return "NexusRepository [name=" + this.name + ", url=" + this.url + ", enabled=" + this.enabled + "]";
    }

    public String getSearchUrl(String sha1) throws UnsupportedEncodingException {
        Assert.isNotNull((Object)sha1);
        StringBuilder searchUrl = this.getBaseUrl().append("service/local/data_index?sha1=").append(URLEncoder.encode(sha1, "UTF-8"));
        return searchUrl.toString();
    }

    public String getSearchUrl(String groupId, String artifactId, String version, String classifier) throws UnsupportedEncodingException {
        Assert.isNotNull((Object)artifactId);
        StringBuilder searchUrl = this.getBaseUrl().append("service/local/data_index?");
        searchUrl.append("a=").append(URLEncoder.encode(artifactId, "UTF-8")).append("&");
        if (groupId != null) {
            searchUrl.append("g=").append(URLEncoder.encode(groupId, "UTF-8")).append("&");
        }
        if (version != null) {
            searchUrl.append("v=").append(URLEncoder.encode(version, "UTF-8")).append("&");
        }
        if (classifier != null) {
            searchUrl.append("c=").append(URLEncoder.encode(classifier, "UTF-8"));
        }
        return searchUrl.toString();
    }

    private StringBuilder getBaseUrl() {
        StringBuilder sb = new StringBuilder();
        String base = this.getUrl();
        sb.append(base);
        if (!base.endsWith(PATH_SEPARATOR)) {
            sb.append(PATH_SEPARATOR);
        }
        return sb;
    }
}

