/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.project.examples.xpl;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.MavenUpdateRequest;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.actions.OpenMavenConsoleAction;
import org.eclipse.m2e.core.ui.internal.util.M2EUIUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.IProgressConstants;

public class UpdateMavenProjectJob
extends WorkspaceJob {
    private final IProject[] projects;
    private final boolean offline;
    private final boolean forceUpdateDependencies;
    private final boolean updateConfiguration;
    private final boolean rebuild;

    public UpdateMavenProjectJob(IProject[] projects, boolean offline, boolean forceUpdateDependencies) {
        this(projects, offline, forceUpdateDependencies, true, true);
    }

    public UpdateMavenProjectJob(IProject[] projects) {
        this(projects, MavenPlugin.getMavenConfiguration().isOffline(), false, true, true);
    }

    public UpdateMavenProjectJob(IProject[] projects, boolean offline, boolean forceUpdateDependencies, boolean updateConfiguration, boolean rebuild) {
        super(Messages.UpdateSourcesAction_job_update_conf);
        this.projects = projects;
        this.offline = offline;
        this.forceUpdateDependencies = forceUpdateDependencies;
        this.updateConfiguration = updateConfiguration;
        this.rebuild = rebuild;
        this.setRule(MavenPlugin.getProjectConfigurationManager().getRule());
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) {
        IProjectConfigurationManager configurationManager = MavenPlugin.getProjectConfigurationManager();
        IMavenProjectRegistry projectRegistry = MavenPlugin.getMavenProjectRegistry();
        boolean autoBuilding = ResourcesPlugin.getWorkspace().isAutoBuilding();
        this.setProperty(IProgressConstants.ACTION_PROPERTY, new OpenMavenConsoleAction());
        monitor.beginTask(this.getName(), this.projects.length);
        IStatus status = null;
        HashMap<String, Throwable> updateErrors = new HashMap<String, Throwable>();
        IProject[] iProjectArray = this.projects;
        int n = this.projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            monitor.subTask(project.getName());
            SubProgressMonitor submonitor = new SubProgressMonitor(monitor, 1, 2);
            try {
                MavenUpdateRequest request = new MavenUpdateRequest(project, this.offline, this.forceUpdateDependencies);
                if (this.updateConfiguration) {
                    configurationManager.updateProjectConfiguration(request, (IProgressMonitor)submonitor);
                } else {
                    projectRegistry.refresh(request, (IProgressMonitor)submonitor);
                }
                if (this.rebuild) {
                    project.build(15, (IProgressMonitor)submonitor);
                    if (autoBuilding) {
                        project.build(10, (IProgressMonitor)submonitor);
                    }
                }
            }
            catch (CoreException ex) {
                if (status == null) {
                    status = new MultiStatus("org.eclipse.m2e.core.ui", 4, Messages.UpdateSourcesAction_error_cannot_update, null);
                }
                status.add(ex.getStatus());
                updateErrors.put(project.getName(), ex);
            }
            catch (IllegalArgumentException e) {
                status = new MultiStatus("org.eclipse.m2e.core.ui", 4, Messages.UpdateSourcesAction_error_cannot_update, null);
                updateErrors.put(project.getName(), e);
            }
            ++n2;
        }
        if (updateErrors.size() > 0) {
            this.handleErrors(updateErrors);
        }
        return status != null ? status : Status.OK_STATUS;
    }

    private void handleErrors(final Map<String, Throwable> updateErrors) {
        final Display display = Display.getDefault();
        if (display != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    M2EUIUtils.showErrorsForProjectsDialog((Shell)display.getActiveShell(), (String)Messages.UpdateSourcesAction_error_title, (String)Messages.UpdateSourcesAction_error_message, (Map)updateErrors);
                }
            });
        }
    }
}

