/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.sourcelookup.containers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.containers.AbstractSourceContainer;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;
import org.jboss.ide.eclipse.as.core.server.IJBossServer;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.ide.eclipse.as.core.server.bean.JBossServerType;
import org.jboss.ide.eclipse.as.core.server.bean.ServerBean;
import org.jboss.ide.eclipse.as.core.server.bean.ServerBeanLoader;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;
import org.jboss.tools.maven.core.identification.IFileIdentificationManager;
import org.jboss.tools.maven.core.identification.IdentificationUtil;
import org.jboss.tools.maven.core.internal.identification.FileIdentificationManager;
import org.jboss.tools.maven.sourcelookup.SourceLookupActivator;

public class JBossSourceContainer
extends AbstractSourceContainer {
    private static final String PATH_SEPARATOR = "/";
    public static final String TYPE_ID = "org.jboss.tools.maven.sourcelookup.containerType";
    public static final String EAP = "EAP";
    public static final String EAP_STD = "EAP_STD";
    public static final String SOA_P = "SOA-P";
    public static final String SOA_P_STD = "SOA-P-STD";
    public static final String EPP = "EPP";
    public static final String EWP = "EWP";
    private List<File> jars;
    private List<ISourceContainer> sourceContainers = new ArrayList<ISourceContainer>();
    protected static File resolvedFile;
    private String homePath;
    private IFileIdentificationManager fileIdentificationManager;

    public JBossSourceContainer(ILaunchConfiguration configuration) throws CoreException {
        IJBossServerRuntime runtime;
        IJBossServer jbossServer;
        IServer server = ServerUtil.getServer((ILaunchConfiguration)configuration);
        if (server != null && (jbossServer = ServerConverter.checkedGetJBossServer((IServer)server)) != null && (runtime = jbossServer.getRuntime()) != null) {
            IPath location = runtime.getRuntime().getLocation();
            this.homePath = location.toOSString();
        }
        if (this.homePath == null) {
            Status status = new Status(4, "org.jboss.tools.maven.sourcelookup.core", "Invalid configuration");
            throw new CoreException((IStatus)status);
        }
        this.fileIdentificationManager = new FileIdentificationManager();
    }

    public JBossSourceContainer(String homePath) {
        this.homePath = homePath;
        this.fileIdentificationManager = new FileIdentificationManager();
    }

    private List<File> getJars() throws CoreException {
        if (this.jars != null) {
            return this.jars;
        }
        this.jars = new ArrayList<File>();
        if (this.homePath == null) {
            return this.jars;
        }
        File location = new File(this.homePath);
        ServerBeanLoader loader = new ServerBeanLoader(location);
        ServerBean serverBean = loader.getServerBean();
        JBossServerType type = serverBean.getType();
        String version = serverBean.getVersion();
        if (JBossServerType.AS7.equals(type) || JBossServerType.AS72.equals(type) || JBossServerType.EAP6.equals(type) || JBossServerType.EAP61.equals(type) || JBossServerType.EAP70.equals(type) || JBossServerType.WILDFLY80.equals(type) || JBossServerType.WILDFLY90.equals(type) || JBossServerType.WILDFLY90_WEB.equals(type) || JBossServerType.WILDFLY100.equals(type) || JBossServerType.WILDFLY100_WEB.equals(type)) {
            this.getJBossModules();
        } else if (JBossServerType.AS.equals(type)) {
            if ("6.0".equals(version) || "6.1".equals(version)) {
                this.getAS6xJars();
            } else if ("5.0".equals(version) || "5.1".equals(version)) {
                this.getAS5xJars();
            }
        } else if (JBossServerType.SOAP.equals(type) || JBossServerType.EAP.equals(type) || JBossServerType.EPP.equals(type) || JBossServerType.SOAP_STD.equals(type) || JBossServerType.EWP.equals(type) || JBossServerType.EAP_STD.equals(type)) {
            this.getAS5xJars();
        }
        if (this.jars.isEmpty()) {
            Path jarPath = new Path(this.homePath);
            this.addJars((IPath)jarPath, this.jars);
        }
        return this.jars;
    }

    private void getAS6xJars() {
        this.getAS5xJars();
    }

    private void getAS5xJars() {
        IPath common = new Path(this.homePath).append("common");
        this.addJars(common, this.jars);
        IPath lib = new Path(this.homePath).append("lib");
        this.addJars(lib, this.jars);
        IPath serverPath = new Path(this.homePath).append("server");
        IPath defaultConfiguration = serverPath.append("default");
        IPath configurationLib = defaultConfiguration.append("lib");
        this.addJars(configurationLib, this.jars);
        IPath deployPath = defaultConfiguration.append("deploy");
        IPath deployLib = deployPath.append("lib");
        this.addJars(deployLib, this.jars);
        IPath jbossweb = deployPath.append("jbossweb.sar");
        this.addJars(jbossweb, this.jars);
        IPath deployers = defaultConfiguration.append("deployers");
        this.addJars(deployers, this.jars);
    }

    private void getJBossModules() {
        IPath modules = new Path(this.homePath).append("modules");
        this.addJars(modules, this.jars);
        IPath bundles = new Path(this.homePath).append("bundles");
        this.addJars(bundles, this.jars);
        File modulesFile = new File(this.homePath, "jboss-modules.jar");
        if (modulesFile.exists()) {
            this.jars.add(modulesFile);
        }
    }

    private void addJars(IPath path, List<File> jars) {
        File[] files;
        File folder = path.toFile();
        if (folder == null || !folder.isDirectory()) {
            return;
        }
        File[] fileArray = files = folder.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                this.addJars(path.append(file.getName()), jars);
            }
            if (file.isFile() && file.getName().endsWith(".jar") && !jars.contains(file)) {
                jars.add(file);
            }
            ++n2;
        }
    }

    public String getName() {
        String name = this.homePath != null ? "JBoss Source Container (" + this.homePath + ")" : "JBoss Source Container";
        return name;
    }

    /*
     * Exception decompiling
     */
    public Object[] findSourceElements(String name) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [19[WHILELOOP]], but top level block is 24[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ArtifactKey getArtifact(File file) throws CoreException {
        return this.fileIdentificationManager.identify(file, (IProgressMonitor)new NullProgressMonitor());
    }

    public static Job downloadArtifact(File file, ArtifactKey artifact) {
        return JBossSourceContainer.downloadArtifact(file, artifact, null);
    }

    public static Job downloadArtifact(File file, ArtifactKey artifact, IJobChangeListener ... listeners) {
        final ArtifactKey sourcesArtifact = new ArtifactKey(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), IdentificationUtil.getSourcesClassifier((String)artifact.getClassifier()));
        resolvedFile = null;
        Job job = new Job("Downloading sources for " + file.getName()){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    resolvedFile = JBossSourceContainer.download(sourcesArtifact, monitor);
                }
                catch (CoreException e) {
                    SourceLookupActivator.logInfo(e.getLocalizedMessage());
                }
                return Status.OK_STATUS;
            }
        };
        if (listeners != null && listeners.length > 0) {
            IJobChangeListener[] iJobChangeListenerArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                IJobChangeListener listener = iJobChangeListenerArray[n2];
                if (listener != null) {
                    job.addJobChangeListener(listener);
                }
                ++n2;
            }
        }
        job.schedule();
        return job;
    }

    private static File download(ArtifactKey artifact, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            return null;
        }
        monitor.beginTask("Downloading sources...", 2);
        monitor.worked(1);
        Artifact resolved = JBossSourceContainer.resolveArtifact(artifact, monitor);
        return resolved.getFile();
    }

    protected static Artifact resolveArtifact(ArtifactKey artifact, IProgressMonitor monitor) throws CoreException {
        IMaven maven = MavenPlugin.getMaven();
        Artifact resolved = maven.resolve(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "jar", artifact.getClassifier(), maven.getArtifactRepositories(), monitor);
        monitor.done();
        return resolved;
    }

    public static IPath getSourcePath(ArtifactKey a) {
        File file = JBossSourceContainer.getAttachedArtifactFile(a, IdentificationUtil.getSourcesClassifier((String)a.getClassifier()));
        if (file != null) {
            return Path.fromOSString((String)file.getAbsolutePath());
        }
        return null;
    }

    private static File getAttachedArtifactFile(ArtifactKey a, String classifier) {
        try {
            IMaven maven = MavenPlugin.getMaven();
            ArtifactRepository localRepository = maven.getLocalRepository();
            String relPath = maven.getArtifactPath(localRepository, a.getGroupId(), a.getArtifactId(), a.getVersion(), "jar", classifier);
            File file = new File(localRepository.getBasedir(), relPath).getCanonicalFile();
            if (file.canRead()) {
                return file;
            }
        }
        catch (CoreException coreException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public ISourceContainerType getType() {
        return this.getSourceContainerType(TYPE_ID);
    }

    public String getHomePath() {
        return this.homePath;
    }
}

