/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.core.internal.adapter.controllers;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IServer;
import org.jboss.tools.openshift.cdk.server.core.internal.CDKCoreActivator;
import org.jboss.tools.openshift.cdk.server.core.internal.MinishiftBinaryUtility;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.AbstractCDKPoller;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDK32Poller;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDK3Server;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.MinishiftPoller;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.controllers.AbstractCDKShutdownController;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.controllers.CDK3LaunchController;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.controllers.CDKLaunchUtility;

public class CDK3ShutdownController
extends AbstractCDKShutdownController {
    @Override
    public void stop(boolean force) {
        this.getBehavior().setServerStopping();
        CDK3Server cdk3 = (CDK3Server)((Object)this.getServer().loadAdapter(CDK3Server.class, (IProgressMonitor)new NullProgressMonitor()));
        String msHome = cdk3.getMinishiftHome();
        if (!new File(msHome).exists()) {
            String msg = "The minishift-home for server \"" + this.getServer().getName() + "\" does not exist: " + msHome + "\n\nPlease make sure that the virtual machine associated with this server has been properly shutdown.";
            Status err = new Status(4, "org.jboss.tools.openshift.cdk.server.core", msg, (Throwable)new Exception(msg));
            CDKCoreActivator.pluginLog().logStatus((IStatus)err);
            this.getBehavior().setServerStopped();
            return;
        }
        this.pollState();
        if (this.getServer().getServerState() == 4) {
            return;
        }
        this.issueShutdownCommand();
    }

    @Override
    protected AbstractCDKPoller getCDKPoller(IServer server) {
        if (server.getServerType().getId().equals("org.jboss.tools.openshift.cdk.server.type.v3")) {
            return new MinishiftPoller();
        }
        return new CDK32Poller();
    }

    @Override
    protected String getShutdownArgs() {
        String profiles = CDK3LaunchController.getProfileString(this.getServer());
        String cmd = String.valueOf(profiles) + "stop";
        return cmd;
    }

    @Override
    protected Process call(IServer s, String cmd, String launchConfigName) throws CoreException, IOException {
        return new CDKLaunchUtility().callMinishiftInteractive(this.getServer(), cmd, this.getServer().getName());
    }

    @Override
    protected boolean useTerminal() {
        return false;
    }

    @Override
    protected String getCommandLocation() {
        return MinishiftBinaryUtility.getMinishiftLocation(this.getServer());
    }
}

