/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.core.internal.adapter.controllers;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.util.ArgsUtil;
import org.jboss.tools.foundation.core.credentials.UsernameChangedException;
import org.jboss.tools.openshift.cdk.server.core.internal.MinishiftBinaryUtility;
import org.jboss.tools.openshift.cdk.server.core.internal.VagrantBinaryUtility;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.controllers.CommandTimeoutException;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.controllers.ExternalLaunchUtil;
import org.jboss.tools.openshift.cdk.server.core.internal.listeners.CDKServerUtility;
import org.jboss.tools.openshift.internal.common.core.util.CommandLocationLookupStrategy;
import org.jboss.tools.openshift.internal.common.core.util.ThreadUtils;

public class CDKLaunchUtility {
    public ILaunchConfigurationWorkingCopy createExternalToolsLaunchConfig(IServer s, String args, String launchConfigName) throws CoreException {
        return this.setupLaunch(s, args, launchConfigName, s.getLaunchConfiguration(true, (IProgressMonitor)new NullProgressMonitor()));
    }

    public ILaunchConfigurationWorkingCopy createExternalToolsVagrantLaunch(IServer s, String args, String launchConfigName, ILaunchConfiguration startupConfig) throws CoreException {
        String commandLoc = VagrantBinaryUtility.getVagrantLocation();
        return this.createExternalToolsLaunch(s, args, launchConfigName, startupConfig, commandLoc);
    }

    public ILaunchConfigurationWorkingCopy createExternalToolsMinishiftLaunch(IServer s, String args, String launchConfigName, ILaunchConfiguration startupConfig) throws CoreException {
        String commandLoc = MinishiftBinaryUtility.getMinishiftLocation();
        return this.createExternalToolsLaunch(s, args, launchConfigName, startupConfig, commandLoc);
    }

    private static final String[] getUserPass(IServer server) {
        CDKServer cdkServer = (CDKServer)((Object)server.loadAdapter(CDKServer.class, (IProgressMonitor)new NullProgressMonitor()));
        String user = cdkServer.getUsername();
        String pass = null;
        try {
            pass = cdkServer.getPassword();
        }
        catch (UsernameChangedException uce) {
            pass = uce.getPassword();
            user = uce.getUser();
        }
        return new String[]{user, pass};
    }

    private static Map<String, String> getEnvironment(IServer s, ILaunchConfiguration startupConfig) throws CoreException {
        CDKServer cdkServer = (CDKServer)((Object)s.loadAdapter(CDKServer.class, (IProgressMonitor)new NullProgressMonitor()));
        boolean passCredentials = cdkServer.passCredentials();
        if (passCredentials) {
            String[] userPass = CDKLaunchUtility.getUserPass(s);
            String userName = userPass[0];
            String pass = userPass[1];
            HashMap existingEnvironment = startupConfig.getAttribute("org.eclipse.debug.core.environmentVariables", null);
            if (existingEnvironment == null) {
                existingEnvironment = new HashMap();
            }
            if (userName == null) {
                throw new CoreException((IStatus)new Status(4, "org.jboss.tools.openshift.cdk.server.core", "The credentials for " + s.getName() + " are invalid. No username found. Please open your server editor " + "and set your access.redhat.com credentials."));
            }
            HashMap<String, String> env = new HashMap<String, String>(existingEnvironment);
            String userKey = cdkServer.getUserEnvironmentKey();
            env.put(userKey, userName);
            String passKey = cdkServer.getPasswordEnvironmentKey();
            if (pass == null) {
                throw new CoreException((IStatus)new Status(4, "org.jboss.tools.openshift.cdk.server.core", "The credentials for " + s.getName() + " are invalid. No password found for username " + cdkServer.getUsername() + " for the access.redhat.com domain. Please open your server editor " + "set your access.redhat.com credentials."));
            }
            if (passKey != null && pass != null) {
                env.put(passKey, pass);
            }
            return env;
        }
        return startupConfig.getAttribute("org.eclipse.debug.core.environmentVariables", null);
    }

    @Deprecated
    public ILaunchConfigurationWorkingCopy setupLaunch(IServer s, String args, String launchConfigName, ILaunchConfiguration startupConfig) throws CoreException {
        String commandLoc = VagrantBinaryUtility.getVagrantLocation();
        return this.setupLaunch(s, args, launchConfigName, startupConfig, commandLoc);
    }

    @Deprecated
    public ILaunchConfigurationWorkingCopy setupLaunch(IServer s, String args, String launchConfigName, ILaunchConfiguration startupConfig, String commandLoc) throws CoreException {
        return this.createExternalToolsLaunch(s, args, launchConfigName, startupConfig, commandLoc);
    }

    public ILaunchConfigurationWorkingCopy createExternalToolsLaunch(IServer s, String args, String launchConfigName, ILaunchConfiguration startupConfig, String commandLoc) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.findLaunchConfig(s, launchConfigName);
        wc.setAttributes(startupConfig.getAttributes());
        wc.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", args);
        Map<String, String> env = CDKLaunchUtility.getEnvironment(s, startupConfig);
        wc.setAttribute("org.eclipse.debug.core.environmentVariables", env);
        if (commandLoc != null) {
            wc.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", commandLoc);
            String cmdFolder = new Path(commandLoc).removeLastSegments(1).toOSString();
            CommandLocationLookupStrategy.get().ensureOnPath(env, cmdFolder);
        }
        return wc;
    }

    private ILaunchConfigurationWorkingCopy findLaunchConfig(IServer s, String launchName) throws CoreException {
        return ExternalLaunchUtil.findExternalToolsLaunchConfig(s, launchName);
    }

    public static String[] convertEnvironment(Map<String, String> env) {
        if (env == null || env.size() == 0) {
            return null;
        }
        HashMap<String, String> original = new HashMap<String, String>(System.getenv());
        original.putAll(env);
        ArrayList<String> ret = new ArrayList<String>();
        Iterator it = original.keySet().iterator();
        String working = null;
        while (it.hasNext()) {
            working = (String)it.next();
            ret.add(String.valueOf(working) + "=" + (String)original.get(working));
        }
        return ret.toArray(new String[ret.size()]);
    }

    public static String[] callMachineReadable(String rootCommand, String[] args, File vagrantDir, Map<String, String> env) throws IOException, CommandTimeoutException {
        return CDKLaunchUtility.call(rootCommand, args, vagrantDir, env, 30000, false);
    }

    private static void ensureCommandOnPath(String rootCommand, Map<String, String> env) {
        CommandLocationLookupStrategy.get().ensureOnPath(env, new Path(rootCommand).removeLastSegments(1).toOSString());
    }

    public Process callInteractive(IServer s, String args, String launchConfigName) throws CoreException, IOException {
        return this.callInteractive(s, args, launchConfigName, s.getLaunchConfiguration(true, (IProgressMonitor)new NullProgressMonitor()));
    }

    public Process callInteractive(IServer s, String args, String launchConfigName, ILaunchConfiguration startupConfig) throws CoreException, IOException {
        Map<String, String> env = CDKLaunchUtility.getEnvironment(s, startupConfig);
        String vagrantcmdloc = VagrantBinaryUtility.getVagrantLocation(s);
        File wd = CDKServerUtility.getWorkingDirectory(s);
        Process p = CDKLaunchUtility.callProcess(vagrantcmdloc, ArgsUtil.parse((String)args), wd, env, true);
        return p;
    }

    public Process callMinishiftInteractive(IServer s, String args, String launchConfigName) throws CoreException, IOException {
        return this.callInteractive(s, args, launchConfigName, s.getLaunchConfiguration(true, (IProgressMonitor)new NullProgressMonitor()));
    }

    public Process callMinishiftConsole(IServer s, String args, String launchConfigName) throws CoreException, IOException {
        Map<String, String> env = CDKLaunchUtility.getEnvironment(s, s.getLaunchConfiguration(true, (IProgressMonitor)new NullProgressMonitor()));
        String minishift = MinishiftBinaryUtility.getMinishiftLocation(s);
        File wd = CDKServerUtility.getWorkingDirectory(s);
        Process p = CDKLaunchUtility.callProcess(minishift, ArgsUtil.parse((String)args), wd, env, false);
        return p;
    }

    public Process callMinishiftInteractive(IServer s, String args, String launchConfigName, ILaunchConfiguration startupConfig) throws CoreException, IOException {
        Map<String, String> env = CDKLaunchUtility.getEnvironment(s, startupConfig);
        String minishiftCmdloc = MinishiftBinaryUtility.getMinishiftLocation(s);
        File wd = JBossServerCorePlugin.getServerStateLocation((IServer)s).toFile();
        Process p = CDKLaunchUtility.callProcess(minishiftCmdloc, ArgsUtil.parse((String)args), wd, env, true);
        return p;
    }

    public static Process callProcess(String rootCommand, String[] args, File vagrantDir, Map<String, String> env, boolean interactive) throws IOException {
        CDKLaunchUtility.ensureCommandOnPath(rootCommand, env);
        String[] envp = env == null ? null : CDKLaunchUtility.convertEnvironment(env);
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(rootCommand);
        cmd.addAll(Arrays.asList(args));
        Process p = null;
        p = interactive ? ProcessFactory.getFactory().exec(cmd.toArray(new String[0]), envp, vagrantDir, new PTY(PTY.Mode.TERMINAL)) : Runtime.getRuntime().exec(cmd.toArray(new String[0]), envp, vagrantDir);
        return p;
    }

    public static String[] call(String rootCommand, String[] args, File vagrantDir, Map<String, String> env, int timeout, boolean interactive) throws IOException, CommandTimeoutException {
        final Process p = CDKLaunchUtility.callProcess(rootCommand, args, vagrantDir, env, interactive);
        InputStream errStream = p.getErrorStream();
        InputStream inStream = p.getInputStream();
        StreamGobbler inGob = new StreamGobbler(inStream);
        StreamGobbler errGob = new StreamGobbler(errStream);
        inGob.start();
        errGob.start();
        Integer exitCode = null;
        exitCode = p.isAlive() ? (Integer)ThreadUtils.runWithTimeout((long)timeout, (Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return p.waitFor();
            }
        }) : Integer.valueOf(p.exitValue());
        List<String> inLines = null;
        if (exitCode == null) {
            inGob.cancel();
            errGob.cancel();
            p.destroyForcibly();
            inLines = inGob.getOutput();
            List<String> errLines = errGob.getOutput();
            throw new CommandTimeoutException(inLines, errLines);
        }
        inLines = inGob.getOutput();
        return inLines.toArray(new String[inLines.size()]);
    }

    private static class StreamGobbler
    extends Thread {
        InputStream is;
        ArrayList<String> ret = new ArrayList();
        private boolean canceled = false;
        private boolean complete = false;
        private static final long MAX_WAIT_AFTER_TERMINATION = 5000L;
        private static final long DELAY = 100L;

        public StreamGobbler(InputStream is) {
            this.is = is;
        }

        private synchronized void add(String line) {
            this.ret.add(line);
        }

        private synchronized ArrayList<String> getList() {
            return this.ret;
        }

        @Override
        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while (!this.isCanceled() && (line = br.readLine()) != null) {
                    this.add(line);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            if (this.is != null) {
                try {
                    this.is.close();
                }
                catch (IOException iOException) {}
            }
            this.setComplete();
        }

        private synchronized void setComplete() {
            this.complete = true;
        }

        private synchronized boolean isComplete() {
            return this.complete;
        }

        private synchronized void setCanceled() {
            this.canceled = true;
        }

        private synchronized boolean isCanceled() {
            return this.canceled;
        }

        public void cancel() {
            this.setCanceled();
            if (this.is != null) {
                try {
                    this.is.close();
                }
                catch (IOException iOException) {}
            }
        }

        private void waitComplete(long delay, long maxwait) {
            long start = System.currentTimeMillis();
            long end = start + maxwait;
            while (!this.isComplete() && System.currentTimeMillis() < end) {
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!this.isComplete()) {
                this.cancel();
            }
        }

        public List<String> getOutput() {
            this.waitComplete(100L, 5000L);
            return this.getList();
        }
    }
}

