/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.core.internal.detection;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.ide.eclipse.as.core.util.ServerNamingUtility;
import org.jboss.tools.foundation.core.credentials.CredentialService;
import org.jboss.tools.foundation.core.credentials.ICredentialDomain;
import org.jboss.tools.openshift.cdk.server.core.internal.CDKCoreActivator;
import org.jboss.tools.runtime.core.model.AbstractRuntimeDetectorDelegate;
import org.jboss.tools.runtime.core.model.RuntimeDefinition;

public abstract class AbstractCDKRuntimeDetector
extends AbstractRuntimeDetectorDelegate {
    public static final String DOT_CDK_SUBSCRIPTION_USERNAME = "rhel.subscription.username";
    public static final String DOT_CDK_SUBSCRIPTION_PASSWORD = "rhel.subscription.password";

    public RuntimeDefinition getRuntimeDefinition(File root, IProgressMonitor monitor) {
        if (this.validate(root)) {
            RuntimeDefinition def = this.createDefinition(this.getDefinitionName(root), this.getDefinitionVersion(root), this.getRuntimeDetectionType(), root);
            this.calculateProblems(def);
            return def;
        }
        return null;
    }

    public boolean initializeRuntime(RuntimeDefinition runtimeDefinition) throws CoreException {
        if (!this.exists(runtimeDefinition) && this.validate(runtimeDefinition.getLocation())) {
            String serverTypeId = this.getServerType();
            IServerType st = ServerCore.findServerType((String)serverTypeId);
            String possibleId = runtimeDefinition.getName();
            String suffixed = ServerNamingUtility.getDefaultServerName((String)possibleId);
            try {
                IServerWorkingCopy wc = st.createServer(suffixed, null, (IProgressMonitor)new NullProgressMonitor());
                this.initializeServer(wc, runtimeDefinition);
                wc.setName(suffixed);
                wc.save(true, (IProgressMonitor)new NullProgressMonitor());
                return true;
            }
            catch (CoreException ce) {
                CDKCoreActivator.pluginLog().logError("Error creating runtime", (Throwable)ce);
            }
        }
        return false;
    }

    protected void addToCredentialsModel(String domainString, String user, String password) {
        ICredentialDomain domain = CredentialService.getCredentialModel().getDomain(domainString);
        if (!domain.userExists(user)) {
            if (password == null || password.isEmpty()) {
                CredentialService.getCredentialModel().addPromptedCredentials(domain, user);
            } else {
                CredentialService.getCredentialModel().addCredentials(domain, user, password);
            }
            CredentialService.getCredentialModel().save();
        }
    }

    protected Properties readProperties(File cdkFile) {
        Properties props = new Properties();
        if (cdkFile.exists()) {
            try {
                Throwable throwable = null;
                Object var4_5 = null;
                try (FileInputStream is = new FileInputStream(cdkFile);){
                    props.load(is);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {}
        }
        return props;
    }

    public boolean exists(RuntimeDefinition runtimeDefinition) {
        if (this.validate(runtimeDefinition.getLocation())) {
            IServer[] ofType = this.findServersOfType(this.getServerType());
            int i = 0;
            while (i < ofType.length) {
                if (ofType[i] != null && this.matches(runtimeDefinition, ofType[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected IServer[] findServersOfType(String type) {
        if (type == null) {
            return new IServer[0];
        }
        ArrayList<IServer> ret = new ArrayList<IServer>();
        IServer[] all = ServerCore.getServers();
        int i = 0;
        while (i < all.length) {
            if (all[i] != null && all[i].getServerType() != null && type.equals(all[i].getServerType().getId())) {
                ret.add(all[i]);
            }
            ++i;
        }
        return ret.toArray(new IServer[ret.size()]);
    }

    protected boolean isHomeDirectory(File root) {
        String home = System.getProperty("user.home");
        return new File(home).equals(root);
    }

    protected boolean validate(File root) {
        String[] required = this.getRequiredChildren();
        int i = 0;
        while (i < required.length) {
            if (!new File(root, required[i]).exists()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void calculateProblems(RuntimeDefinition def) {
        super.calculateProblems(def);
    }

    protected abstract boolean matches(RuntimeDefinition var1, IServer var2);

    protected abstract String getServerType();

    protected abstract String[] getRequiredChildren();

    protected abstract String getDefinitionName(File var1);

    protected abstract String getRuntimeDetectionType();

    protected abstract String getDefinitionVersion(File var1);

    protected abstract void initializeServer(IServerWorkingCopy var1, RuntimeDefinition var2) throws CoreException;
}

