/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.core.internal.detection;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.jboss.dmr.ModelNode;
import org.jboss.tools.openshift.cdk.server.core.internal.CDKCoreActivator;
import org.jboss.tools.openshift.cdk.server.core.internal.MinishiftBinaryUtility;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDK3Server;
import org.jboss.tools.openshift.cdk.server.core.internal.detection.AbstractCDKRuntimeDetector;
import org.jboss.tools.runtime.core.model.RuntimeDefinition;
import org.jboss.tools.runtime.core.model.RuntimeDetectionProblem;

public class CDK3RuntimeDetector
extends AbstractCDKRuntimeDetector {
    public static final String CDK_RUNTIME_TYPE = "CDK 3";
    public static final String PROP_CDK_VERSION = "cdk.version";
    public static final String OVERRIDE_MINISHIFT_LOCATION = "OVERRIDE_MINISHIFT_LOCATION";

    @Override
    protected boolean validate(File root) {
        String vers;
        boolean matchesEnvVar;
        boolean matchesHomeMinishift = this.isHomeDirectory(root.getParentFile()) && ".minishift".equals(root.getName()) && super.validate(root);
        String envvar = System.getenv("MINISHIFT_HOME");
        boolean bl = matchesEnvVar = envvar != null && new File(envvar).exists() && super.validate(root);
        return (matchesHomeMinishift || matchesEnvVar) && this.matchesExpectedVersion(vers = this.getDefinitionVersion(root));
    }

    protected boolean matchesExpectedVersion(String version) {
        return CDK3Server.matchesCDK3(version);
    }

    @Override
    protected boolean matches(RuntimeDefinition def, IServer server) {
        String fromServer = server.getAttribute("minishift.file.location", null);
        String fromProblemResolver = (String)def.getProperty(OVERRIDE_MINISHIFT_LOCATION);
        String fromPath = MinishiftBinaryUtility.getMinishiftLocation();
        if (fromServer == null) {
            return fromPath == null && fromProblemResolver == null;
        }
        if (fromProblemResolver != null) {
            return fromProblemResolver.equals(fromServer);
        }
        return fromPath == null ? true : fromPath.equals(fromServer);
    }

    @Override
    protected String getServerType() {
        return "org.jboss.tools.openshift.cdk.server.type.v3";
    }

    @Override
    protected String[] getRequiredChildren() {
        return new String[]{"cdk", "config", "config/config.json"};
    }

    @Override
    protected String getDefinitionName(File root) {
        return CDK3Server.getServerTypeBaseName();
    }

    @Override
    protected String getRuntimeDetectionType() {
        return CDK_RUNTIME_TYPE;
    }

    @Override
    protected String getDefinitionVersion(File root) {
        File cdkFile = new File(root, "cdk");
        Properties props = this.readProperties(cdkFile);
        String version = props.getProperty(PROP_CDK_VERSION);
        version = version == null ? "3.0" : version;
        return version;
    }

    @Override
    protected void initializeServer(IServerWorkingCopy wc, RuntimeDefinition runtimeDefinition) throws CoreException {
        String folder = runtimeDefinition.getLocation().getAbsolutePath();
        File cdkFile = new File(folder, "cdk");
        Properties props = this.readProperties(cdkFile);
        String user = props.getProperty("rhel.subscription.username");
        String password = System.getenv("rhel.subscription.password");
        if (user != null) {
            this.addToCredentialsModel("access.redhat.com", user, password);
        }
        wc.setAttribute("minishift.home.location", folder);
        wc.setAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.hypervisor", this.getHypervisor(folder));
        wc.setAttribute("org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer.username", user);
        wc.setAttribute("minishift.file.location", this.getMinishiftLoc(runtimeDefinition));
    }

    private String getHypervisor(String folder) {
        String[] validHypervisors = CDK3Server.getHypervisors();
        String hyperV = validHypervisors[0];
        File config = new File(folder, "config");
        File configJson = new File(config, "config.json");
        if (!configJson.exists() || !configJson.isFile()) {
            return hyperV;
        }
        String path = configJson.getAbsolutePath();
        try {
            String val;
            String content = new String(Files.readAllBytes(Paths.get(path, new String[0])));
            ModelNode mn = ModelNode.fromJSONString((String)content);
            ModelNode o = mn.get("vm-driver");
            String string = val = o == null ? null : o.asString();
            if (val != null && Arrays.asList(validHypervisors).contains(val)) {
                return val;
            }
        }
        catch (IOException e) {
            CDKCoreActivator.pluginLog().logError((Throwable)e);
        }
        return hyperV;
    }

    private String getMinishiftLoc(RuntimeDefinition runtimeDefinition) {
        String fromDef = (String)runtimeDefinition.getProperty(OVERRIDE_MINISHIFT_LOCATION);
        if (fromDef != null && !fromDef.isEmpty() && new File(fromDef).exists()) {
            return fromDef;
        }
        return MinishiftBinaryUtility.getMinishiftLocation();
    }

    @Override
    public void calculateProblems(RuntimeDefinition def) {
        String override = (String)def.getProperty(OVERRIDE_MINISHIFT_LOCATION);
        String minishiftLoc = MinishiftBinaryUtility.getMinishiftLocation();
        if (this.doesNotExist(override) && this.doesNotExist(minishiftLoc)) {
            RuntimeDetectionProblem p = this.createDetectionProblem("Set minishift binary location.", "The minishift binary could not be located on the system path.", 4, 2008);
            def.setProblems(new RuntimeDetectionProblem[]{p});
        } else {
            def.setProblems(new RuntimeDetectionProblem[0]);
        }
    }

    private boolean doesNotExist(String s) {
        return s == null || s.isEmpty() || !new File(s).exists();
    }
}

