/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.core.internal.listeners;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.wst.server.core.IServer;
import org.jboss.tools.foundation.core.credentials.UsernameChangedException;
import org.jboss.tools.openshift.cdk.server.core.internal.CDKCoreActivator;
import org.jboss.tools.openshift.cdk.server.core.internal.adapter.CDKServer;

public class CDKLaunchEnvironmentUtil {
    public static Map<String, String> createEnvironment(IServer server) {
        CDKServer cdkServer = (CDKServer)((Object)server.loadAdapter(CDKServer.class, (IProgressMonitor)new NullProgressMonitor()));
        boolean passCredentials = cdkServer.passCredentials();
        String pass = null;
        if (passCredentials) {
            try {
                pass = cdkServer.getPassword();
            }
            catch (UsernameChangedException uce) {
                return CDKLaunchEnvironmentUtil.createEnvironment(server, uce.getPassword(), uce.getUser());
            }
        }
        return CDKLaunchEnvironmentUtil.createEnvironment(server, pass);
    }

    public static Map<String, String> createEnvironment(IServer server, String password) {
        CDKServer cdkServer = (CDKServer)((Object)server.loadAdapter(CDKServer.class, (IProgressMonitor)new NullProgressMonitor()));
        return CDKLaunchEnvironmentUtil.createEnvironment(server, password, cdkServer.getUsername());
    }

    public static Map<String, String> createEnvironment(IServer server, String password, String user) {
        Map launchEnv = null;
        try {
            ILaunchConfiguration wc = server.getLaunchConfiguration(false, (IProgressMonitor)new NullProgressMonitor());
            if (wc != null) {
                launchEnv = wc.getAttribute("org.eclipse.debug.core.environmentVariables", null);
            }
        }
        catch (CoreException coreException) {
            CDKCoreActivator.pluginLog().logWarning("Unable to load environment for vagrant status call. System environment will be used instead.");
        }
        HashMap<String, String> systemEnv = new HashMap<String, String>(System.getenv());
        if (launchEnv != null) {
            Iterator it = launchEnv.keySet().iterator();
            String k = null;
            while (it.hasNext()) {
                k = (String)it.next();
                systemEnv.put(k, (String)launchEnv.get(k));
            }
        }
        CDKServer cdkServer = (CDKServer)((Object)server.loadAdapter(CDKServer.class, (IProgressMonitor)new NullProgressMonitor()));
        boolean passCredentials = cdkServer.passCredentials();
        String userKey = cdkServer.getUserEnvironmentKey();
        String passKey = cdkServer.getPasswordEnvironmentKey();
        if (passCredentials) {
            systemEnv.put(userKey, user);
            systemEnv.put(passKey, password);
        } else {
            systemEnv.remove(userKey);
            systemEnv.remove(passKey);
        }
        return systemEnv;
    }
}

