/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.core.internal.registry;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.tools.openshift.cdk.server.core.internal.listeners.CDKOpenshiftUtility;
import org.jboss.tools.openshift.cdk.server.core.internal.listeners.ServiceManagerEnvironment;
import org.jboss.tools.openshift.cdk.server.core.internal.listeners.ServiceManagerEnvironmentLoader;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.core.connection.registry.IConnectionRegistryProvider;

public class CDKRegistryProvider
implements IConnectionRegistryProvider {
    private Pair findServer(IConnection connection) {
        CDKOpenshiftUtility util = new CDKOpenshiftUtility();
        IServer[] all = ServerCore.getServers();
        MultiStatus ms = new MultiStatus("org.jboss.tools.openshift.cdk.server.core", 0, "CDKRegistryProvider unable to locate a registry URL for openshift connection " + connection.toString(), null);
        if (all.length == 0) {
            ms.add((IStatus)new Status(4, "org.jboss.tools.openshift.cdk.server.core", "No Servers exist in the workspace."));
        }
        boolean foundMinishift = false;
        int i = 0;
        while (i < all.length) {
            ServiceManagerEnvironment env = this.getServiceManagerEnvironment(all[i]);
            ServiceManagerEnvironmentLoader type = ServiceManagerEnvironmentLoader.type(all[i]);
            if (type.getType() == 2) {
                foundMinishift = true;
                if (all[i].getServerState() != 2) {
                    ms.add((IStatus)new Status(1, "org.jboss.tools.openshift.cdk.server.core", "Unable to locate the CDK environment details for stopped server " + all[i].getName()));
                } else if (env == null) {
                    ms.add((IStatus)new Status(1, "org.jboss.tools.openshift.cdk.server.core", "Unable to locate the CDK environment details for server " + all[i].getName()));
                } else if (!util.serverMatchesConnection(all[i], connection, env)) {
                    ms.add((IStatus)util.serverConnectionMatchError(all[i], connection, env));
                } else {
                    String registry = env.getDockerRegistry();
                    if (registry == null || registry.isEmpty()) {
                        String s = "Server {0} does not have a registry associated with it. Please verify that 'minishift openshift registry' returns a valid URL.";
                        ms.add((IStatus)new Status(1, "org.jboss.tools.openshift.cdk.server.core", NLS.bind((String)s, (Object)all[i].getName())));
                    } else {
                        return new Pair(null, all[i]);
                    }
                }
            }
            ++i;
        }
        if (all.length > 0 && !foundMinishift) {
            ms.add((IStatus)new Status(4, "org.jboss.tools.openshift.cdk.server.core", "No valid CDK Servers exist in the workspace."));
        }
        return new Pair(ms, null);
    }

    protected ServiceManagerEnvironment getServiceManagerEnvironment(IServer server) {
        ServiceManagerEnvironmentLoader type = ServiceManagerEnvironmentLoader.type(server);
        if (!(type instanceof ServiceManagerEnvironmentLoader.NullEnvironmentLoader)) {
            ServiceManagerEnvironment adb = type.getOrLoadServiceManagerEnvironment(server, true);
            return adb;
        }
        return null;
    }

    public IStatus getRegistryURL(IConnection connection) {
        Pair s = this.findServer(connection);
        if (s != null && s.s != null) {
            ServiceManagerEnvironment env = this.getServiceManagerEnvironment(s.s);
            return new Status(0, "org.jboss.tools.openshift.cdk.server.core", env.getDockerRegistry());
        }
        return s.ms;
    }

    private class Pair {
        private MultiStatus ms;
        private IServer s;

        public Pair(MultiStatus ms, IServer s) {
            this.ms = ms;
            this.s = s;
        }
    }
}

