/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.ui.internal;

import java.io.File;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;
import org.jboss.ide.eclipse.as.core.util.ServerAttributeHelper;
import org.jboss.ide.eclipse.as.wtp.ui.editor.ServerWorkingCopyPropertyTextCommand;

public abstract class AbstractLocationSection
extends ServerEditorSection {
    protected static final boolean FILE = true;
    protected static final boolean FOLDER = false;
    private Text location;
    private Button browse;
    protected ServerAttributeHelper helper;
    private SelectionListener browseListener;
    private ModifyListener locationListener;
    private String commandName;
    private String locationAttribute;
    private String sectionTitle;
    private String labelString;
    protected ControlDecoration txtDecorator;

    public AbstractLocationSection(String sectionTitle, String labelString, String commandName, String locationAttribute) {
        this.sectionTitle = sectionTitle;
        this.labelString = labelString;
        this.commandName = commandName;
        this.locationAttribute = locationAttribute;
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.helper = new ServerAttributeHelper(this.server.getOriginal(), this.server);
    }

    public void createSection(Composite parent) {
        super.createSection(parent);
        this.createUI(parent);
        this.setDefaultValues();
        this.addListeners();
        this.validate();
    }

    protected void createUI(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Section section = toolkit.createSection(parent, 322);
        section.setText(this.sectionTitle);
        section.setLayoutData((Object)new GridData(784));
        Composite composite = toolkit.createComposite((Composite)section);
        composite.setLayout((Layout)new GridLayout(5, false));
        this.fillUI(toolkit, composite);
        section.setClient((Control)composite);
    }

    protected void fillUI(FormToolkit toolkit, Composite composite) {
        this.createLocationWidgets(toolkit, composite);
    }

    protected void createLocationWidgets(FormToolkit toolkit, Composite composite) {
        toolkit.createLabel(composite, this.labelString);
        this.location = toolkit.createText(composite, "", 2052);
        this.browse = toolkit.createButton(composite, "Browse...", 8);
        this.location.setLayoutData((Object)GridDataFactory.defaultsFor((Control)this.location).span(3, 1).minSize(150, -1).create());
        this.txtDecorator = new ControlDecoration((Control)this.location, 16512);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        Image img = fieldDecoration.getImage();
        this.txtDecorator.setImage(img);
        this.txtDecorator.hide();
    }

    protected Text getLocationText() {
        return this.location;
    }

    protected void setDefaultValues() {
        String s = this.server.getAttribute(this.locationAttribute, null);
        this.location.setText(s == null ? "" : s);
    }

    protected void addListeners() {
        this.browseListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractLocationSection.this.locationBrowseClicked();
                AbstractLocationSection.this.validate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.browse.addSelectionListener(this.browseListener);
        this.locationListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractLocationSection.this.execute((IUndoableOperation)new SetLocationPropertyCommand(AbstractLocationSection.this.server));
            }
        };
        this.location.addModifyListener(this.locationListener);
        this.location.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractLocationSection.this.validate();
            }
        });
    }

    protected void validate() {
    }

    protected abstract void locationBrowseClicked();

    protected void browseClicked(Text text, boolean type) {
        String newVal;
        File file;
        if (text == null) {
            return;
        }
        File file2 = file = text.getText() == null ? null : new File(text.getText());
        if (file != null && !file.exists()) {
            file = null;
        }
        File f2 = null;
        if (type) {
            f2 = AbstractLocationSection.chooseFile(file, text.getShell());
        } else if (!type) {
            f2 = AbstractLocationSection.chooseDirectory(file, text.getShell());
        }
        if (f2 != null && (newVal = f2.getAbsolutePath()) != null && !newVal.equals(text.getText())) {
            text.setText(newVal);
        }
    }

    protected static File chooseFile(File startingDirectory, Shell shell) {
        String dir;
        FileDialog fileDialog = new FileDialog(shell, 4096);
        if (startingDirectory != null) {
            if (startingDirectory.isFile()) {
                fileDialog.setFilterPath(startingDirectory.getParentFile().getPath());
            } else {
                fileDialog.setFilterPath(startingDirectory.getPath());
            }
        }
        if ((dir = fileDialog.open()) != null && (dir = dir.trim()).length() > 0) {
            return new File(dir);
        }
        return null;
    }

    protected static File chooseDirectory(File startingDirectory, Shell shell) {
        String dir;
        DirectoryDialog fileDialog = new DirectoryDialog(shell, 4096);
        if (startingDirectory != null) {
            fileDialog.setFilterPath(startingDirectory.getPath());
        }
        if ((dir = fileDialog.open()) != null && (dir = dir.trim()).length() > 0) {
            return new File(dir);
        }
        return null;
    }

    public class SetLocationPropertyCommand
    extends ServerWorkingCopyPropertyTextCommand {
        public SetLocationPropertyCommand(IServerWorkingCopy server) {
            super(server, AbstractLocationSection.this.commandName, AbstractLocationSection.this.location, AbstractLocationSection.this.location.getText(), AbstractLocationSection.this.locationAttribute, AbstractLocationSection.this.locationListener);
        }
    }
}

