/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.cdk.server.ui.internal.view;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.ServerEvent;
import org.eclipse.wst.server.ui.internal.view.servers.AbstractServerAction;
import org.jboss.ide.eclipse.as.core.server.UnitedServerListener;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ControllableServerBehavior;
import org.jboss.tools.openshift.cdk.server.core.internal.CDKCoreActivator;
import org.jboss.tools.openshift.cdk.server.core.internal.listeners.CDKDockerUtility;
import org.jboss.tools.openshift.cdk.server.core.internal.listeners.CDKOpenshiftUtility;
import org.jboss.tools.openshift.cdk.server.core.internal.listeners.ServiceManagerEnvironment;
import org.jboss.tools.openshift.internal.ui.models.OpenshiftUIModel;

public class CDKActionProvider
extends CommonActionProvider {
    private ICommonActionExtensionSite actionSite;
    private ShowInViewAfterStartupAction showInOpenshiftViewAction;
    private ShowInViewAfterStartupAction showInDockerViewAction;
    private static final String DOCKER_VIEW_ID = "org.eclipse.linuxtools.docker.ui.dockerExplorerView";
    private static final String OPENSHIFT_VIEW_ID = "org.jboss.tools.openshift.express.ui.explorer.expressConsoleView";

    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        this.actionSite = aSite;
        this.createActions(aSite);
    }

    protected void createActions(ICommonActionExtensionSite aSite) {
        ICommonViewerSite site = aSite.getViewSite();
        if (site instanceof ICommonViewerWorkbenchSite) {
            ICommonViewerWorkbenchSite wsSite = (ICommonViewerWorkbenchSite)site;
            this.showInOpenshiftViewAction = new ShowInOpenshiftViewAfterStartupAction(wsSite.getSelectionProvider(), OPENSHIFT_VIEW_ID);
            this.showInDockerViewAction = new ShowInDockerViewAfterStartupAction(wsSite.getSelectionProvider(), DOCKER_VIEW_ID);
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        IServer server;
        IContributionItem quick;
        ICommonViewerSite site = this.actionSite.getViewSite();
        IStructuredSelection selection = null;
        if (site instanceof ICommonViewerWorkbenchSite) {
            ICommonViewerWorkbenchSite wsSite = (ICommonViewerWorkbenchSite)site;
            selection = (IStructuredSelection)wsSite.getSelectionProvider().getSelection();
        }
        if ((quick = menu.find("org.eclipse.ui.navigate.showInQuickMenu")) != null && selection != null && selection.size() == 1 && selection.getFirstElement() instanceof IServer && this.acceptsServer(server = (IServer)selection.getFirstElement()) && menu instanceof MenuManager) {
            ((MenuManager)quick).add((IAction)this.showInDockerViewAction);
            ((MenuManager)quick).add((IAction)this.showInOpenshiftViewAction);
        }
    }

    private boolean acceptsServer(IServer s) {
        String typeId;
        return s != null && s.getServerType() != null && ("org.jboss.tools.openshift.cdk.server.type".equals(typeId = s.getServerType().getId()) || "org.jboss.tools.openshift.cdk.server.type.v3".equals(typeId));
    }

    private static final IWorkbenchPart bringViewToFront(String viewId) throws PartInitException {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IViewPart part = null;
        if (window != null && (page = window.getActivePage()) != null) {
            part = page.findView(viewId);
            if (part == null) {
                part = page.showView(viewId);
            } else {
                page.activate((IWorkbenchPart)part);
                part.setFocus();
            }
        }
        return part;
    }

    private static class ShowInDockerViewAfterStartupAction
    extends ShowInViewAfterStartupAction {
        public ShowInDockerViewAfterStartupAction(ISelectionProvider sp, String viewId) {
            super(sp, viewId);
        }

        @Override
        protected Object adaptToViewItem(IServer server) {
            if (server != null) {
                return new CDKDockerUtility().findDockerConnection(server.getName());
            }
            return null;
        }
    }

    private static class ShowInOpenshiftViewAfterStartupAction
    extends ShowInViewAfterStartupAction {
        public ShowInOpenshiftViewAfterStartupAction(ISelectionProvider sp, String viewId) {
            super(sp, viewId);
        }

        @Override
        protected Object adaptToViewItem(IServer server) {
            ControllableServerBehavior beh = (ControllableServerBehavior)server.loadAdapter(ControllableServerBehavior.class, (IProgressMonitor)new NullProgressMonitor());
            ServiceManagerEnvironment adb = null;
            if (beh != null) {
                adb = (ServiceManagerEnvironment)beh.getSharedData("cdk.sharedinfo.serviceManagerEnvironment");
            }
            if (adb != null) {
                return OpenshiftUIModel.getInstance().getConnectionWrapperForConnection(new CDKOpenshiftUtility().findExistingOpenshiftConnection(server, adb));
            }
            return null;
        }
    }

    private static abstract class ShowInViewAfterStartupAction
    extends AbstractServerAction {
        private IStructuredSelection previousSelection;
        private IServerListener serverListener;
        private String viewId;

        public ShowInViewAfterStartupAction(ISelectionProvider sp, String viewId) {
            super(sp, null);
            this.viewId = viewId;
            IViewRegistry reg = PlatformUI.getWorkbench().getViewRegistry();
            IViewDescriptor desc = reg.find(viewId);
            this.setText(desc.getLabel());
            this.setImageDescriptor(desc.getImageDescriptor());
            this.serverListener = new IServerListener(){

                public void serverChanged(final ServerEvent event) {
                    if (previousSelection != null && previousSelection.size() > 0 && previousSelection.getFirstElement().equals(event.getServer())) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (UnitedServerListener.serverSwitchesToState((ServerEvent)event, (int)2)) {
                                    this.setEnabled(true);
                                } else if (UnitedServerListener.serverSwitchesToState((ServerEvent)event, (int)4)) {
                                    this.setEnabled(false);
                                }
                            }
                        });
                    }
                }
            };
            this.selectionChanged(sp.getSelection());
        }

        protected abstract Object adaptToViewItem(IServer var1);

        public boolean accept(IServer server) {
            boolean preconditions = server.getServerType() != null && this.adaptToViewItem(server) != null && server.getServerState() == 2;
            return preconditions;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void selectionChanged(IStructuredSelection sel) {
            if (sel.size() != 1) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(true);
            ShowInViewAfterStartupAction showInViewAfterStartupAction = this;
            synchronized (showInViewAfterStartupAction) {
                this.switchListener(this.previousSelection, sel);
                this.previousSelection = sel;
            }
            super.selectionChanged(sel);
        }

        private void switchListener(IStructuredSelection previousSelection, IStructuredSelection newSel) {
            Object newSel1;
            Object o;
            if (previousSelection != null && (o = previousSelection.getFirstElement()) instanceof IServer) {
                ((IServer)o).removeServerListener(this.serverListener);
            }
            if ((newSel1 = newSel.getFirstElement()) instanceof IServer) {
                ((IServer)newSel1).addServerListener(this.serverListener);
            }
        }

        public void perform(IServer server) {
            Object connection;
            CommonNavigator view;
            IWorkbenchPart part = null;
            try {
                part = CDKActionProvider.bringViewToFront(this.viewId);
            }
            catch (PartInitException pie) {
                CDKCoreActivator.pluginLog().logError("Error opening view " + this.viewId, (Throwable)pie);
            }
            if (part != null && (view = (CommonNavigator)part.getAdapter(CommonNavigator.class)) != null && view.getCommonViewer() != null && view.getCommonViewer().getTree() != null && !view.getCommonViewer().getTree().isDisposed() && (connection = this.adaptToViewItem(server)) != null) {
                view.getCommonViewer().expandToLevel(connection, 1);
                StructuredSelection sel = new StructuredSelection(new Object[]{connection});
                view.getCommonViewer().setSelection((ISelection)sel, true);
            }
        }
    }
}

