/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.client.internal.log;

import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugTrace;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

public class Trace {
    public static final String GLOBAL_DEBUG_KEY = "/debug";
    public static final String CLIENT_DEBUG_KEY = "/debug/client";
    private static final boolean DEFAULT_DEBUG = false;
    private String pluginId;
    private DebugOptions options;
    private ServiceTracker<DebugOptions, DebugOptions> tracker;
    private DebugTrace trace;

    public Trace(String pluginId) {
        this.pluginId = pluginId;
    }

    public void close() {
        if (this.tracker != null) {
            this.tracker.close();
        }
    }

    private DebugOptions createDebugOptions() {
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        if (bundle == null) {
            return null;
        }
        BundleContext context = bundle.getBundleContext();
        if (context == null) {
            return null;
        }
        this.tracker = new ServiceTracker(context, DebugOptions.class.getName(), null);
        this.tracker.open();
        return (DebugOptions)this.tracker.getService();
    }

    public boolean isDebugging() {
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        if (bundle == null) {
            return false;
        }
        DebugOptions debugOptions = this.getDebugOptions();
        if (debugOptions == null) {
            return false;
        }
        if (!debugOptions.isDebugEnabled()) {
            return false;
        }
        if (!debugOptions.getBooleanOption(String.valueOf(this.pluginId) + GLOBAL_DEBUG_KEY, false)) {
            return false;
        }
        return debugOptions.getBooleanOption(String.valueOf(this.pluginId) + CLIENT_DEBUG_KEY, false);
    }

    private DebugTrace getDebugTrace() {
        if (this.trace == null) {
            this.trace = this.getDebugOptions().newDebugTrace(this.pluginId);
        }
        return this.trace;
    }

    public void trace(String option, String message) {
        this.getDebugTrace().trace(GLOBAL_DEBUG_KEY + option, message);
    }

    private DebugOptions getDebugOptions() {
        if (this.options == null) {
            this.options = this.createDebugOptions();
        }
        return this.options;
    }
}

