/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.common.core.connection;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.common.core.connection.IConnectionFactory;
import org.jboss.tools.openshift.common.core.connection.IConnectionsFactory;
import org.jboss.tools.openshift.internal.common.core.OpenShiftCommonCoreActivator;
import org.osgi.util.tracker.ServiceTracker;

public class ConnectionsFactoryTracker
extends ServiceTracker<IConnectionsFactory, IConnectionsFactory>
implements IConnectionsFactory {
    public ConnectionsFactoryTracker() {
        super(OpenShiftCommonCoreActivator.getBundleContext(), IConnectionsFactory.class, null);
    }

    @Override
    public IConnection create(String host) throws IOException {
        IConnectionsFactory service = (IConnectionsFactory)this.getService();
        if (service == null) {
            return null;
        }
        return service.create(host);
    }

    @Override
    public IConnectionFactory getFactory(String host) throws IOException {
        IConnectionsFactory service = (IConnectionsFactory)this.getService();
        if (service == null) {
            return null;
        }
        return service.getFactory(host);
    }

    @Override
    public IConnectionFactory getById(String id) {
        IConnectionsFactory service = (IConnectionsFactory)this.getService();
        if (service == null) {
            return null;
        }
        return service.getById(id);
    }

    @Override
    public Collection<IConnectionFactory> getAll() {
        IConnectionsFactory service = (IConnectionsFactory)this.getService();
        if (service == null) {
            return null;
        }
        return service.getAll();
    }

    @Override
    public <T extends IConnection> Collection<IConnectionFactory> getAll(Class<T> clazz) {
        if (clazz == null) {
            return this.getAll();
        }
        return Arrays.asList(this.getByConnection(clazz));
    }

    @Override
    public <T extends IConnection> IConnectionFactory getByConnection(Class<T> clazz) {
        IConnectionsFactory service = (IConnectionsFactory)this.getService();
        if (service == null) {
            return null;
        }
        return service.getByConnection(clazz);
    }
}

