/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.common.core.connection;

import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import org.jboss.tools.openshift.common.core.connection.HumanReadableX509Certificate;

public class HostCertificate {
    private boolean accepted = false;
    private X509Certificate certificate;

    public HostCertificate(boolean accepted, X509Certificate certificate) {
        this.accepted = accepted;
        this.certificate = certificate;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public void setAccepted(boolean checked) {
        this.accepted = checked;
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        return this.certificate.getEncoded();
    }

    public boolean isValid() {
        if (this.certificate == null) {
            return false;
        }
        try {
            this.certificate.checkValidity();
        }
        catch (CertificateExpiredException | CertificateNotYetValidException certificateException) {
            return false;
        }
        return true;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.certificate == null ? 0 : this.certificate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HostCertificate other = (HostCertificate)obj;
        return !(this.certificate == null ? other.certificate != null : !this.certificate.equals(other.certificate));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Accepted:").append('\t').append(this.accepted).append('\n');
        if (this.certificate != null) {
            HumanReadableX509Certificate humanCertificate = new HumanReadableX509Certificate(this.certificate);
            sb.append("Issued To:").append('\t').append(humanCertificate.getIssuedTo()).append('\n');
            sb.append("Issued By:").append('\t').append(humanCertificate.getIssuedBy()).append('\n');
            sb.append("Validity:").append('\t').append(humanCertificate.getValidity()).append('\n');
            sb.append("SHA1 Fingerprint:").append('\t').append(humanCertificate.getFingerprint()).append('\n');
        }
        return sb.toString();
    }
}

